/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.querybuilder.sql.dialect;

import ro.nextreports.engine.querybuilder.sql.dialect.ColumnTypeParser;

public class ColumnTypeMatcher {
    private ColumnTypeParser parser;

    public ColumnTypeMatcher(String columnType) {
        this.parser = new ColumnTypeParser(columnType);
        try {
            this.parser.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean matchType(String type) {
        return this.parser.getType().equalsIgnoreCase(type);
    }

    public boolean matchPrecision(int precision) {
        if (this.parser.getPrecision() == Integer.MIN_VALUE) {
            return true;
        }
        String precissionOperator = this.parser.getPrecissionOperator();
        if (precissionOperator == null) {
            return this.parser.getPrecision() == precision;
        }
        return this.evaluateExpression(precision, precissionOperator, this.parser.getPrecision());
    }

    public boolean matchScale(int scale) {
        if (this.parser.getScale() == Integer.MIN_VALUE) {
            return true;
        }
        String scaleOperator = this.parser.getScaleOperator();
        if (scaleOperator == null) {
            return this.parser.getScale() == scale;
        }
        return this.evaluateExpression(scale, scaleOperator, this.parser.getScale());
    }

    public String getColumnType() {
        return this.parser.getColumnType();
    }

    private boolean evaluateExpression(int leftOperand, String operator, int rightOperand) {
        if (">=".equals(operator)) {
            return leftOperand >= rightOperand;
        }
        if ("<=".equals(operator)) {
            return leftOperand <= rightOperand;
        }
        if (">".equals(operator)) {
            return leftOperand > rightOperand;
        }
        if ("<".equals(operator)) {
            return leftOperand < rightOperand;
        }
        throw new IllegalStateException("Unsupported operator");
    }
}

