/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.querybuilder.sql.dialect;

import java.util.ArrayList;
import java.util.List;

class ColumnTypeParser {
    public static final String WILDCARD = "*";
    public static final String GREATER = ">";
    public static final String GREATER_EQUAL = ">=";
    public static final String LESS = "<";
    public static final String LESS_EQUAL = "<=";
    public static final int ALL = Integer.MIN_VALUE;
    private static final List<String> allOperators = new ArrayList<String>();
    private String columnType;
    private String type;
    private int precision;
    private String precissionOperator;
    private int scale;
    private String scaleOperator;

    public ColumnTypeParser(String columnType) {
        this.columnType = columnType;
    }

    public String getColumnType() {
        return this.columnType;
    }

    public String getType() {
        return this.type;
    }

    public int getPrecision() {
        return this.precision;
    }

    public String getPrecissionOperator() {
        return this.precissionOperator;
    }

    public int getScale() {
        return this.scale;
    }

    public String getScaleOperator() {
        return this.scaleOperator;
    }

    public void parse() throws Exception {
        String column = new String(this.columnType).trim();
        int x = column.indexOf(40);
        if (x == -1) {
            this.type = column;
            this.precision = Integer.MIN_VALUE;
            this.scale = Integer.MIN_VALUE;
        } else {
            this.type = column.substring(0, x).trim();
            String s = column.substring(x);
            if ('(' != s.charAt(0)) {
                throw new Exception("Missing '(' for '" + this.columnType + "'");
            }
            if (')' != s.charAt(s.length() - 1)) {
                throw new Exception("Missing ')' for '" + this.columnType + "'");
            }
            String[] tmp = (s = s.substring(1, s.length() - 1).trim()).split(",");
            if (tmp.length != 2) {
                throw new Exception("Missing precision and/or scale for '" + this.columnType + "'");
            }
            s = tmp[0].trim();
            this.precissionOperator = this.getOperator(s);
            if (this.precissionOperator != null) {
                s = s.substring(this.precissionOperator.length());
            }
            this.precision = WILDCARD.equals(s = s.trim()) ? Integer.MIN_VALUE : Integer.parseInt(s.trim());
            s = tmp[1].trim();
            this.scaleOperator = this.getOperator(s);
            if (this.scaleOperator != null) {
                s = s.substring(this.scaleOperator.length());
            }
            this.scale = WILDCARD.equals(s = s.trim()) ? Integer.MIN_VALUE : Integer.parseInt(s.trim());
        }
    }

    private String getOperator(String s) {
        if (s.startsWith(GREATER_EQUAL)) {
            return GREATER_EQUAL;
        }
        if (s.startsWith(LESS_EQUAL)) {
            return LESS_EQUAL;
        }
        if (s.startsWith(GREATER)) {
            return GREATER;
        }
        if (s.startsWith(LESS)) {
            return LESS;
        }
        return null;
    }

    public static void main(String[] args) {
        ColumnTypeParser parser = new ColumnTypeParser("varchar(3, *)");
        try {
            parser.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        System.out.println("type = " + parser.getType());
        System.out.println("precision = " + parser.getPrecision());
        System.out.println("precissionOperator = " + parser.getPrecissionOperator());
        System.out.println("scale = " + parser.getScale());
        System.out.println("scaleOperator = " + parser.getScaleOperator());
    }

    static {
        allOperators.add(GREATER);
        allOperators.add(GREATER_EQUAL);
        allOperators.add(LESS);
        allOperators.add(LESS_EQUAL);
    }
}

