/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.querybuilder.sql.dialect;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ro.nextreports.engine.querybuilder.sql.dialect.CSVDialect;
import ro.nextreports.engine.querybuilder.sql.dialect.DerbyDialect;
import ro.nextreports.engine.querybuilder.sql.dialect.Dialect;
import ro.nextreports.engine.querybuilder.sql.dialect.DialectException;
import ro.nextreports.engine.querybuilder.sql.dialect.FirebirdDialect;
import ro.nextreports.engine.querybuilder.sql.dialect.MSAccessDialect;
import ro.nextreports.engine.querybuilder.sql.dialect.MSSQLDialect;
import ro.nextreports.engine.querybuilder.sql.dialect.MySQLDialect;
import ro.nextreports.engine.querybuilder.sql.dialect.OracleDialect;
import ro.nextreports.engine.querybuilder.sql.dialect.PervasiveDialect;
import ro.nextreports.engine.querybuilder.sql.dialect.PostrgreSQLDialect;
import ro.nextreports.engine.querybuilder.sql.dialect.SQLiteDialect;
import ro.nextreports.engine.querybuilder.sql.dialect.TeradataDialect;
import ro.nextreports.engine.querybuilder.sql.dialect.VerticaDialect;

public class DialectFactory {
    private static final String DATABASE = "next.dialect.database";
    private static final String DIALECT = "next.dialect.class";
    private static Log LOG = LogFactory.getLog(DialectFactory.class);
    private static final Map<String, DialectMapper> MAPPERS = new HashMap<String, DialectMapper>();
    public static final String ORACLE = "Oracle";
    public static final String SYBASE9 = "Adaptive Server Anywhere";
    public static final String MSSQL = "Microsoft SQL Server";
    public static final String MySQL = "MySQL";
    public static final String DERBY = "Apache Derby";
    public static final String POSTGRES = "PostgreSQL";
    public static final String FIREBIRD = "Firebird";
    public static final String SQLITE = "SQLite";
    public static final String CSV = "CsvJdbc";
    public static final String VERTICA = "Vertica Database";
    public static final String PERVASIVE = "Pervasive.SQL";
    public static final String TERADATA = "Teradata";
    public static final String MSACCESS = "Ucanaccess";

    public static Dialect determineDialect(String databaseName, String databaseMajorVersion) throws DialectException {
        String dialectName;
        if (databaseName == null) {
            throw new DialectException("Dialect must be explicitly set");
        }
        if (databaseName.startsWith(FIREBIRD)) {
            dialectName = FirebirdDialect.class.getName();
        } else if (databaseName.startsWith(MSACCESS)) {
            dialectName = MSAccessDialect.class.getName();
        } else {
            DialectMapper mapper = MAPPERS.get(databaseName);
            if (mapper == null) {
                throw new DialectException("Dialect must be explicitly set for database: " + databaseName);
            }
            dialectName = mapper.getDialectClass(databaseMajorVersion);
        }
        return DialectFactory.buildDialect(dialectName);
    }

    public static Dialect buildDialect(String dialectName) throws DialectException {
        try {
            return (Dialect)DialectFactory.loadDialect(dialectName).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new DialectException("Dialect class not found: " + dialectName);
        }
        catch (Exception e) {
            throw new DialectException("Could not instantiate dialect class", e);
        }
    }

    private static Class loadDialect(String dialectName) throws ClassNotFoundException {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(dialectName);
            }
            return Class.forName(dialectName);
        }
        catch (Exception e) {
            return Class.forName(dialectName);
        }
    }

    public static void addDialect(String dialectName, String dialectClass) {
        MAPPERS.put(dialectName, new VersionInsensitiveMapper(dialectClass));
        LOG.info((Object)("Dialect added: " + dialectName + " = " + dialectClass));
    }

    private static void addDialectsFromVMParameters() {
        Properties properties = System.getProperties();
        for (Object key : properties.keySet()) {
            String name;
            if (!(key instanceof String) || !(name = (String)key).startsWith(DATABASE)) continue;
            String databaseName = properties.getProperty(name);
            int index = name.indexOf("_");
            if (index <= 0) continue;
            String suffix = name.substring(index);
            String dialectClass = properties.getProperty(DIALECT + suffix);
            if (dialectClass == null) continue;
            DialectFactory.addDialect(databaseName, dialectClass);
        }
    }

    static {
        DialectFactory.addDialect(ORACLE, OracleDialect.class.getName());
        DialectFactory.addDialect(SYBASE9, MSSQLDialect.class.getName());
        DialectFactory.addDialect(MSSQL, MSSQLDialect.class.getName());
        DialectFactory.addDialect(MySQL, MySQLDialect.class.getName());
        DialectFactory.addDialect(DERBY, DerbyDialect.class.getName());
        DialectFactory.addDialect(POSTGRES, PostrgreSQLDialect.class.getName());
        DialectFactory.addDialect(SQLITE, SQLiteDialect.class.getName());
        DialectFactory.addDialect(CSV, CSVDialect.class.getName());
        DialectFactory.addDialect(VERTICA, VerticaDialect.class.getName());
        DialectFactory.addDialect(PERVASIVE, PervasiveDialect.class.getName());
        DialectFactory.addDialect(TERADATA, TeradataDialect.class.getName());
        DialectFactory.addDialect(MSACCESS, MSAccessDialect.class.getName());
        DialectFactory.addDialectsFromVMParameters();
    }

    public static class VersionInsensitiveMapper
    implements DialectMapper {
        private String dialectClassName;

        public VersionInsensitiveMapper(String dialectClassName) {
            this.dialectClassName = dialectClassName;
        }

        @Override
        public String getDialectClass(String majorVersion) {
            return this.dialectClassName;
        }
    }

    public static interface DialectMapper {
        public String getDialectClass(String var1);
    }
}

