/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.querybuilder.sql.dialect;

import ro.nextreports.engine.querybuilder.sql.dialect.AbstractDialect;
import ro.nextreports.engine.querybuilder.sql.dialect.DialectException;

public class FirebirdDialect
extends AbstractDialect {
    public FirebirdDialect() {
        this.registerColumnType("smallint", 5);
        this.registerColumnType("numeric(18, 0)", -5);
        this.registerColumnType("integer", 4);
        this.registerColumnType("char(1, *)", -7);
        this.registerColumnType("char(>1, *)", 12);
        this.registerColumnType("varchar", 12);
        this.registerColumnType("float", 6);
        this.registerColumnType("double", 8);
        this.registerColumnType("double precision", 8);
        this.registerColumnType("date", 91);
        this.registerColumnType("decimal", 4);
        this.registerColumnType("time", 92);
        this.registerColumnType("timestamp", 93);
        this.registerColumnType("numeric", 2);
        this.registerColumnType("blob", 2004);
        this.registerColumnType("blob sub_type 1", 2005);
    }

    @Override
    public String getCurrentDate() throws DialectException {
        return "current_date";
    }

    @Override
    public String getCurrentTimestamp() throws DialectException {
        return "current_timestamp";
    }

    @Override
    public String getCurrentTime() throws DialectException {
        return "current_time";
    }

    @Override
    public String getCurrentDateSelect() {
        return "select current_date from rdb$database;";
    }

    @Override
    public String getRecycleBinTablePrefix() {
        return null;
    }

    @Override
    public String getCursorSqlTypeName() {
        return "REF CURSOR";
    }

    @Override
    public int getCursorSqlType() {
        return 1111;
    }

    @Override
    public String getSqlChecker() {
        return "select 1 from rdb$database;";
    }

    @Override
    public boolean needsHoldCursorsForPreparedStatement() {
        return true;
    }

    @Override
    protected void setKeywords() {
        this.keywords = new String[]{"ACTION", "ACTIVE", "ADD", "ADMIN", "AFTER", "ALL", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASCENDING", "AT", "AUTO", "AUTODDL", "AVG", "BASED", "BASENAME", "BASE_NAME", "BEFORE", "BEGIN", "BETWEEN", "BLOB", "BLOBEDIT", "BUFFER", "BY", "CACHE", "CASCADE", "CAST", "CHAR", "CHARACTER", "CHAR_LENGTH", "CHARACTER_LENGTH", "CHECK", "CHECK_POINT_LEN", "CHECK_POINT_LENGTH", "CLOSE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "COMMITTED", "COMPILETIME", "COMPUTED", "CONDITIONAL", "CONNECT", "CONSTRAINT", "CONTAINING", "CONTINUE", "COUNT", "CREATE", "CSTRING", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DATABASE", "DATE", "DAY", "DB_KEY", "DEBUG", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELETE", "DESC", "DESCENDING", "DESCRIBE", "DESCRIPTOR", "DISCONNECT", "DISPLAY", "DISTINCT", "DO", "DOMAIN", "DOUBLE", "DROP", "ECHO", "EDIT", "ELSE", "END", "ENTRY_POINT", "ESCAPE", "EVENT", "EXCEPTION", "EXECUTE", "EXISTS", "EXIT", "EXTERN", "EXTERNAL", "EXTRACT", "FETCH", "FILE", "FILTER", "FLOAT", "FOR", "FOREIGN", "FOUND", "FREE_IT", "FROM", "FULL", "FUNCTION", "GDSCODE", "GENERATOR", "GEN_ID", "GLOBAL", "GOTO", "GRANT", "GROUP", "GROUP_COMMIT_WAIT", "GROUP_COMMIT_WAIT_TIME", "HAVING", "HELP", "HOUR", "IF", "IMMEDIATE", "IN", "INACTIVE", "INDEX", "INDICATOR", "INIT", "INNER", "INPUT", "INPUT_TYPE", "INSERT", "INT", "INTEGER", "INTO", "IS", "ISOLATION", "ISQL", "JOIN", "KEY", "LC_MESSAGES", "LC_TYPE", "LEFT", "LENGTH", "LEV", "LEVEL", "LIKE", "LOGFILE", "LOG_BUFFER_SIZE", "LOG_BUF_SIZE", "LONG", "MANUAL", "MAX", "MAXIMUM", "MAXIMUM_SEGMENT", "MAX_SEGMENT", "MERGE", "MESSAGE", "MIN", "MINIMUM", "MINUTE", "MODULE_NAME", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NO", "NOAUTO", "NOT", "NULL", "NUM_LOG_BUFS", "NUM_LOG_BUFFERS", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "OUTPUT_TYPE", "OVERFLOW", "PAGE", "PAGELENGTH", "PAGES", "PAGE_SIZE", "PARAMETER", "PASSWORD", "PLAN", "POSITION", "POST_EVENT", "PRECISION", "PREPARE", "PRIMARY", "PRIVILEGES", "PROCEDURE", "PUBLIC", "QUIT", "RAW_PARTITIONS", "RDB$DB_KEY", "READ", "REAL", "RECORD_VERSION", "REFERENCES", "RELEASE", "RESERV", "RESERVING", "RESTRICT", "RETAIN", "RETURN", "RETURNING_VALUES", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "RUNTIME", "SCHEMA", "SECOND", "SELECT", "SET", "SHADOW", "SHARED", "SHELL", "SHOW", "SINGULAR", "SIZE", "SMALLINT", "SNAPSHOT", "SOME", "SORT", "SQL", "SQLCODE", "SQLERROR", "SQLWARNING", "STABILITY", "STARTING", "STARTS", "STATEMENT", "STATIC", "STATISTICS", "SUB_TYPE", "SUM", "SUSPEND", "TABLE", "TERMINATOR", "THEN", "TIME", "TIMESTAMP", "TO", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIGGER", "TRIM", "TYPE", "UNCOMMITTED", "UNION", "UNIQUE", "UPDATE", "UPPER", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARIABLE", "VARYING", "VERSION", "VIEW", "WAIT", "WEEKDAY", "WHEN", "WHENEVER", "WHILE", "WITH", "WORK", "WRITE", "YEAR", "YEARDAY"};
    }

    @Override
    public String getEscapedKeyWord(String keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException("Keyword cannot be null!");
        }
        return "\"" + keyword + "\"";
    }
}

