/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.querybuilder.sql.dialect;

import ro.nextreports.engine.querybuilder.sql.dialect.AbstractDialect;
import ro.nextreports.engine.querybuilder.sql.dialect.DialectException;

public class MSSQLDialect
extends AbstractDialect {
    public MSSQLDialect() {
        this.registerColumnType("bit", -7);
        this.registerColumnType("bigint", -5);
        this.registerColumnType("bigint identity", -5);
        this.registerColumnType("smallint", 5);
        this.registerColumnType("smallint identity", 5);
        this.registerColumnType("tinyint", -6);
        this.registerColumnType("tinyint identity", -6);
        this.registerColumnType("int", 4);
        this.registerColumnType("int identity", 4);
        this.registerColumnType("float", 6);
        this.registerColumnType("decimal", 3);
        this.registerColumnType("double", 8);
        this.registerColumnType("real", 8);
        this.registerColumnType("numeric", 2);
        this.registerColumnType("numeric identity", 2);
        this.registerColumnType("uniqueidentifier", 1);
        this.registerColumnType("char", 1);
        this.registerColumnType("nchar", 1);
        this.registerColumnType("varchar", 12);
        this.registerColumnType("nvarchar", 12);
        this.registerColumnType("text", 12);
        this.registerColumnType("ntext", 12);
        this.registerColumnType("date", 91);
        this.registerColumnType("smalldatetime", 93);
        this.registerColumnType("datetime", 93);
        this.registerColumnType("timestamp", 93);
        this.registerColumnType("money", 3);
        this.registerColumnType("smallmoney", 3);
        this.registerColumnType("blob", 2004);
        this.registerColumnType("varbinary", 2004);
        this.registerColumnType("image", 2004);
        this.registerColumnType("clob", 2005);
    }

    @Override
    public String getCurrentDate() throws DialectException {
        return "getdate()";
    }

    @Override
    public String getCurrentDateSelect() {
        return "select getdate()";
    }

    @Override
    public String getRecycleBinTablePrefix() {
        return null;
    }

    @Override
    public String getCursorSqlTypeName() {
        return "REF CURSOR";
    }

    @Override
    public int getCursorSqlType() {
        return 1111;
    }

    @Override
    public boolean schemaBeforeCatalog() {
        return false;
    }

    @Override
    public String getSqlChecker() {
        return "SELECT 1";
    }

    @Override
    protected void setKeywords() {
        this.keywords = new String[]{"ADD", "ALTER", "AND", "ANY", "AS", "ASC", "AUTHORIZATION", "BACKUP", "BEGIN", "BETWEEN", "BREAK", "BROWSE", "BULK", "BY", "CASCADE", "CASE", "CHECK", "CHECKPOINT", "CLOSE", "CLUSTERED", "COALESCE", "COLLATE", "COLUMN", "COMMIT", "COMPUTE", "CONSTRAINT", "CONTAINS", "CONTAINSTABLE", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATABASE", "DBCC", "DEALLOCATE", "DECLARE", "DEFAULT", "DELETE", "DENY", "DESC", "DISK", "DISTINCT", "DISTRIBUTED", "DOUBLE", "DROP", "DUMMY", "DUMP", "ELSE", "END", "ERRLVL", "ESCAPE", "EXCEPT", "EXECUTE", "EXISTS", "EXIT", "FETCH", "FILE", "FILLFACTOR", "FOR", "FOREIGN", "FREETEXT", "FREETEXTTABLE", "FROM", "FULL", "FUNCTION", "GOTO", "GRANT", "GROUP", "HAVING", "HOLDLOCK", "IDENTITY", "IDENTITY_INSERT", "IDENTITYCOL", "IF", "IN", "INDEX", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "KEY", "KILL", "LEFT", "LIKE", "LINENO", "LOAD", "NATIONAL", "NOCHECK", "NONCLUSTERED", "NOT", "NULL", "NULLIF", "OF", "OFF", "OFFSETS", "ON", "OPEN", "OPENDATASOURCE", "OPENQUERY", "OPENROWSET", "OPENXML", "OPTION", "OR", "ORDER", "OUTER", "OVER", "PERCENT", "PLAN", "PRECISION", "PRIMARY", "PRINT", "PROC", "PROCEDURE", "PUBLIC", "RAISERROR", "READ", "READTEXT", "RECONFIGURE", "REFERENCES", "REPLICATION", "RESTORE", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "ROLLBACK", "ROWCOUNT", "ROWGUIDCOL", "RULE", "SAVE", "SCHEMA", "SELECT", "SESSION_USER", "SET", "SETUSER", "SHUTDOWN", "SOME", "STATISTICS", "SYSTEM_USER", "TABLE", "TEXTSIZE", "THEN", "TO", "TOP", "TRAN", "TRANSACTION", "TRIGGER", "TRUNCATE", "TSEQUAL", "UNION", "UNIQUE", "UPDATE", "UPDATETEXT", "USE", "USER", "VALUES", "VARYING", "VIEW", "WAITFOR", "WHEN", "WHERE", "WHILE", "WITH", "WRITETEXT"};
    }

    @Override
    public String getEscapedKeyWord(String keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException("Keyword cannot be null!");
        }
        return "[" + keyword + "]";
    }
}

