/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.querybuilder.sql.dialect;

import ro.nextreports.engine.querybuilder.sql.dialect.AbstractDialect;
import ro.nextreports.engine.querybuilder.sql.dialect.DialectException;

public class MySQLDialect
extends AbstractDialect {
    public MySQLDialect() {
        this.registerColumnType("bit", -7);
        this.registerColumnType("bigint", -5);
        this.registerColumnType("bigint unsigned", -5);
        this.registerColumnType("smallint", 5);
        this.registerColumnType("smallint unsigned", 5);
        this.registerColumnType("tinyint", -6);
        this.registerColumnType("tinyint unsigned", -6);
        this.registerColumnType("integer", 4);
        this.registerColumnType("integer unsigned", -5);
        this.registerColumnType("int", 4);
        this.registerColumnType("int unsigned", -5);
        this.registerColumnType("float", 6);
        this.registerColumnType("decimal", 3);
        this.registerColumnType("decimal unsigned", 3);
        this.registerColumnType("double", 8);
        this.registerColumnType("numeric", 2);
        this.registerColumnType("char", 1);
        this.registerColumnType("varchar", 12);
        this.registerColumnType("text", 12);
        this.registerColumnType("date", 91);
        this.registerColumnType("time", 93);
        this.registerColumnType("datetime", 93);
        this.registerColumnType("timestamp", 93);
        this.registerColumnType("blob", 2004);
        this.registerColumnType("longblob", 2004);
        this.registerColumnType("mediumblob", 2004);
        this.registerColumnType("varbinary", 2004);
        this.registerColumnType("clob", 2005);
    }

    @Override
    public String getCurrentDate() throws DialectException {
        return "curdate()";
    }

    @Override
    public String getCurrentDateSelect() {
        return "select curdate()";
    }

    @Override
    public String getRecycleBinTablePrefix() {
        return null;
    }

    @Override
    public String getCursorSqlTypeName() {
        return "REF CURSOR";
    }

    @Override
    public int getCursorSqlType() {
        return 1111;
    }

    @Override
    public String getSqlChecker() {
        return "SELECT 1";
    }

    @Override
    protected void setKeywords() {
        this.keywords = new String[]{"ACCESSIBLE", "ALTER", "AS", "BEFORE", "BINARY", "BY", "CASE", "CHARACTER", "COLUMN", "CONTINUE", "CROSS", "CURRENT_TIMESTAMP", "DATABASE", "DAY_MICROSECOND", "DEC", "DEFAULT", "DESC", "DISTINCT", "DOUBLE", "EACH", "ENCLOSED", "EXIT", "FETCH", "FLOAT8", "FOREIGN", "GRANT", "HIGH_PRIORITY", "HOUR_SECOND", "IN", "INNER", "INSERT", "INT2", "INT8", "INTO", "JOIN", "KILL", "LEFT", "LINEAR", "LOCALTIME", "LONG", "LOOP", "MATCH", "MEDIUMTEXT", "MINUTE_SECOND", "NATURAL", "NULL", "OPTIMIZE", "OR", "OUTER", "PRIMARY", "RANGE", "READ_WRITE", "REGEXP", "REPEAT", "RESTRICT", "RIGHT", "SCHEMAS", "SENSITIVE", "SHOW", "SPECIFIC", "SQLSTATE", "SQL_CALC_FOUND_ROWS", "STARTING", "TERMINATED", "TINYINT", "TRAILING", "UNDO", "UNLOCK", "USAGE", "UTC_DATE", "VALUES", "VARCHARACTER", "WHERE", "WRITE", "ZEROFILL", "ALL", "AND", "ASENSITIVE", "BIGINT", "BOTH", "CASCADE", "CHAR", "COLLATE", "CONSTRAINT", "CREATE", "CURRENT_TIME", "CURSOR", "DAY_HOUR", "DAY_SECOND", "DECLARE", "DELETE", "DETERMINISTIC", "DIV", "DUAL", "ELSEIF", "EXISTS", "FALSE", "FLOAT4", "FORCE", "FULLTEXT", "HAVING", "HOUR_MINUTE", "IGNORE", "INFILE", "INSENSITIVE", "INT1", "INT4", "INTERVAL", "ITERATE", "KEYS", "LEAVE", "LIMIT", "LOAD", "LOCK", "LONGTEXT", "MASTER_SSL_VERIFY_SERVER_CERT", "MEDIUMINT", "MINUTE_MICROSECOND", "MODIFIES", "NO_WRITE_TO_BINLOG", "ON", "OPTIONALLY", "OUT", "PRECISION", "PURGE", "READS", "REFERENCES", "RENAME", "REQUIRE", "REVOKE", "SCHEMA", "SELECT", "SET", "SPATIAL", "SQLEXCEPTION", "SQL_BIG_RESULT", "SSL", "TABLE", "TINYBLOB", "TO", "TRUE", "UNIQUE", "UPDATE", "USING", "UTC_TIMESTAMP", "VARCHAR", "WHEN", "WITH", "YEAR_MONTH", "ADD", "ANALYZE", "ASC", "BETWEEN", "BLOB", "CALL", "CHANGE", "CHECK", "CONDITION", "CONVERT", "CURRENT_DATE", "CURRENT_USER", "DATABASES", "DAY_MINUTE", "DECIMAL", "DELAYED", "DESCRIBE", "DISTINCTROW", "DROP", "ELSE", "ESCAPED", "EXPLAIN", "FLOAT", "FOR", "FROM", "GROUP", "HOUR_MICROSECOND", "IF", "INDEX", "INOUT", "INT", "INT3", "INTEGER", "IS", "KEY", "LEADING", "LIKE", "LINES", "LOCALTIMESTAMP", "LONGBLOB", "LOW_PRIORITY", "MEDIUMBLOB", "MIDDLEINT", "MOD", "NOT", "NUMERIC", "OPTION", "ORDER", "OUTFILE", "PROCEDURE", "READ", "REAL", "RELEASE", "REPLACE", "RETURN", "RLIKE", "SECOND_MICROSECOND", "SEPARATOR", "SMALLINT", "SQL", "SQLWARNING", "SQL_SMALL_RESULT", "STRAIGHT_JOIN", "THEN", "TINYTEXT", "TRIGGER", "UNION", "UNSIGNED", "USE", "UTC_TIME", "VARBINARY", "VARYING", "WHILE", "XOR"};
    }

    @Override
    public String getEscapedKeyWord(String keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException("Keyword cannot be null!");
        }
        return "`" + keyword + "`";
    }
}

