/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.querybuilder.sql.dialect;

import ro.nextreports.engine.querybuilder.sql.dialect.AbstractDialect;
import ro.nextreports.engine.querybuilder.sql.dialect.DialectException;

public class OracleDialect
extends AbstractDialect {
    public static String ORACLE_CLIENT_PROPERTY = "oracle.net.tns_admin";

    public OracleDialect() {
        this.registerColumnType("bit", -7);
        this.registerColumnType("bigint", 4);
        this.registerColumnType("smallint", 5);
        this.registerColumnType("tinyint", -6);
        this.registerColumnType("integer", 4);
        this.registerColumnType("int", 4);
        this.registerColumnType("float", 6);
        this.registerColumnType("decimal", 4);
        this.registerColumnType("double", 8);
        this.registerColumnType("numeric", 2);
        this.registerColumnType("number(*, <0)", 2);
        this.registerColumnType("number(*, 0)", 4);
        this.registerColumnType("number(*, >0)", 8);
        this.registerColumnType("char", 1);
        this.registerColumnType("varchar", 12);
        this.registerColumnType("varchar2", 12);
        this.registerColumnType("date", 91);
        this.registerColumnType("datetime", 93);
        this.registerColumnType("timestamp", 93);
        this.registerColumnType("blob", 2004);
        this.registerColumnType("varbinary", 2004);
        this.registerColumnType("clob", 2005);
    }

    @Override
    public String getCurrentDate() throws DialectException {
        return "sysdate";
    }

    @Override
    public String getCurrentDateSelect() {
        return "select sysdate from dual";
    }

    @Override
    public String getRecycleBinTablePrefix() {
        return "BIN$";
    }

    @Override
    public String getCursorSqlTypeName() {
        return "REF CURSOR";
    }

    @Override
    public int getCursorSqlType() {
        return -10;
    }

    @Override
    public boolean hasProcedureWithCursor() {
        return true;
    }

    @Override
    public String getSqlChecker() {
        return "SELECT 1 FROM DUAL";
    }

    @Override
    protected void setKeywords() {
        this.keywords = new String[]{"ADMIN", "CURSOR", "FOUND", "MOUNT", "AFTER", "CYCLE", "FUNCTION", "NEXT", "ALLOCATE", "DATABASE", "GO", "NEW", "ANALYZE", "DATAFILE", "GOTO", "NOARCHIVELOG", "ARCHIVE", "DBA", "GROUPS", "NOCACHE", "ARCHIVELOG", "DEC", "INCLUDING", "NOCYCLE", "AUTHORIZATION", "DECLARE", "INDICATOR", "NOMAXVALUE", "AVG", "DISABLE", "INITRANS", "NOMINVALUE", "BACKUP", "DISMOUNT", "INSTANCE", "NONE", "BEGIN", "DOUBLE", "INT", "NOORDER", "BECOME", "DUMP", "KEY", "NORESETLOGS", "BEFORE", "EACH", "LANGUAGE", "NORMAL", "BLOCK", "ENABLE", "LAYER", "NOSORT", "BODY", "END", "LINK", "NUMERIC", "CACHE", "ESCAPE", "LISTS", "OFF", "CANCEL", "EVENTS", "LOGFILE", "OLD", "CASCADE", "EXCEPT", "MANAGE", "ONLY", "CHANGE", "EXCEPTIONS", "MANUAL", "OPEN", "CHARACTER", "EXEC", "MAX", "OPTIMAL", "CHECKPOINT", "EXPLAIN", "MAXDATAFILES", "OWN", "CLOSE", "EXECUTE", "MAXINSTANCES", "PACKAGE", "COBOL", "EXTENT", "MAXLOGFILES", "PARALLEL", "COMMIT", "EXTERNALLY", "MAXLOGHISTORY", "PCTINCREASE", "COMPILE", "FETCH", "MAXLOGMEMBERS", "PCTUSED", "CONSTRAINT", "FLUSH", "MAXTRANS", "PLAN", "CONSTRAINTS", "FREELIST", "MAXVALUE", "PLI", "CONTENTS", "FREELISTS", "MIN", "PRECISION", "CONTINUE", "FORCE", "MINEXTENTS", "PRIMARY", "CONTROLFILE", "FOREIGN", "MINVALUE", "PRIVATE", "COUNT", "FORTRAN", "MODULE", "PROCEDURE", "PROFILE", "SAVEPOINT", "SQLSTATE", "TRACING", "QUOTA", "SCHEMA", "STATEMENT_ID", "TRANSACTION", "READ", "SCN", "STATISTICS", "TRIGGERS", "REAL", "SECTION", "STOP", "TRUNCATE", "RECOVER", "SEGMENT", "STORAGE", "UNDER", "REFERENCES", "SEQUENCE", "SUM", "UNLIMITED", "REFERENCING", "SHARED", "SWITCH", "UNTIL", "RESETLOGS", "SNAPSHOT", "SYSTEM", "USE", "RESTRICTED", "SOME", "TABLES", "USING", "REUSE", "SORT", "TABLESPACE", "WHEN", "ROLE", "SQL", "TEMPORARY", "WRITE", "ROLES", "SQLCODE", "THREAD", "WORK", "ROLLBACK", "SQLERROR", "TIME"};
    }

    @Override
    public String getEscapedKeyWord(String keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException("Keyword cannot be null!");
        }
        return "\"" + keyword.toUpperCase() + "\"";
    }
}

