/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.queryexec;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import ro.nextreports.engine.queryexec.QueryChunk;

public class Query {
    protected List<QueryChunk> chunks = new ArrayList<QueryChunk>();
    protected List<String> parameterNames = new ArrayList<String>();
    private String text;

    public Query(String text) {
        this.setText(this.removeComments(text));
    }

    public QueryChunk[] getChunks() {
        if (this.chunks == null || this.chunks.size() == 0) {
            return new QueryChunk[0];
        }
        QueryChunk[] chunkArray = new QueryChunk[this.chunks.size()];
        this.chunks.toArray(chunkArray);
        return chunkArray;
    }

    public String[] getParameterNames() {
        if (this.parameterNames == null || this.parameterNames.size() == 0) {
            return new String[0];
        }
        String[] parameterNamesArray = new String[this.parameterNames.size()];
        this.parameterNames.toArray(parameterNamesArray);
        return parameterNamesArray;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (text == null) {
            return;
        }
        this.text = text;
        this.chunks = new ArrayList<QueryChunk>();
        this.parameterNames = new ArrayList<String>();
        int end = 0;
        StringBuffer textChunk = new StringBuffer();
        String parameterChunk = null;
        StringTokenizer st = new StringTokenizer(text, "$", true);
        String token = null;
        boolean wasDelim = false;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.equals("$")) {
                if (wasDelim) {
                    textChunk.append("$");
                }
                wasDelim = true;
                continue;
            }
            if (token.startsWith("{") && wasDelim) {
                end = token.indexOf(125);
                if (end > 0) {
                    if (textChunk.length() > 0) {
                        this.addTextChunk(textChunk.toString());
                    }
                    parameterChunk = token.substring(1, end);
                    this.parameterNames.add(parameterChunk);
                    this.addParameterChunk(parameterChunk);
                    textChunk = new StringBuffer(token.substring(end + 1));
                } else {
                    if (wasDelim) {
                        textChunk.append("$");
                    }
                    textChunk.append(token);
                }
            } else {
                if (wasDelim) {
                    textChunk.append("$");
                }
                textChunk.append(token);
            }
            wasDelim = false;
        }
        if (wasDelim) {
            textChunk.append("$");
        }
        if (textChunk.length() > 0) {
            this.addTextChunk(textChunk.toString());
        }
    }

    private void addTextChunk(String text) {
        QueryChunk chunk = new QueryChunk();
        chunk.setType((byte)1);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    private void addParameterChunk(String text) {
        QueryChunk chunk = new QueryChunk();
        chunk.setType((byte)2);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    private String removeComments(String text) {
        if (text == null) {
            return text;
        }
        Scanner scanner = new Scanner(text);
        StringBuilder sb = new StringBuilder();
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            int commentIndex = line.indexOf("--");
            if (commentIndex == -1) {
                sb.append(line);
                sb.append("\r\n");
                continue;
            }
            if (commentIndex <= 0 || "".equals((line = line.substring(0, commentIndex)).trim())) continue;
            sb.append(line);
            sb.append("\r\n");
        }
        sb.delete(sb.toString().length() - 2, sb.toString().length());
        scanner.close();
        return sb.toString();
    }
}

