/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.queryexec;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ro.nextreports.engine.querybuilder.IdNameRenderer;
import ro.nextreports.engine.querybuilder.sql.dialect.CSVDialect;
import ro.nextreports.engine.querybuilder.sql.dialect.ConnectionUtil;
import ro.nextreports.engine.querybuilder.sql.dialect.Dialect;
import ro.nextreports.engine.querybuilder.sql.dialect.DialectException;
import ro.nextreports.engine.querybuilder.sql.dialect.OracleDialect;
import ro.nextreports.engine.querybuilder.sql.dialect.SQLiteDialect;
import ro.nextreports.engine.queryexec.IdName;
import ro.nextreports.engine.queryexec.Query;
import ro.nextreports.engine.queryexec.QueryChunk;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.queryexec.QueryParameter;
import ro.nextreports.engine.queryexec.QueryResult;
import ro.nextreports.engine.queryexec.util.StringUtil;
import ro.nextreports.engine.util.DialectUtil;
import ro.nextreports.engine.util.ParameterUtil;
import ro.nextreports.engine.util.QueryUtil;

public class QueryExecutor
implements Runnable {
    public static final int DEFAULT_TIMEOUT = 20;
    public static final int DEFAULT_MAX_ROWS = 100;
    public static final String EQUAL = "=";
    public static final String NOT_EQUAL = "<>";
    public static final String GREATER = ">";
    public static final String GREATER_EQUAL = ">=";
    public static final String LESS = "<";
    public static final String LESS_EQUAL = "<=";
    public static final String LIKE = "LIKE";
    public static final String NOT_LIKE = "NOT LIKE";
    public static final String IN = "IN";
    public static final String NOT_IN = "NOT IN";
    public static final String BETWEEN = "BETWEEN";
    public static final String AND = "AND";
    public static final String NOT = "NOT";
    private static Log LOG = LogFactory.getLog(QueryExecutor.class);
    private Query query;
    private Map<String, QueryParameter> parameters = new HashMap<String, QueryParameter>();
    private Map<String, Object> parameterValues;
    private List<String> parameterNames = new ArrayList<String>();
    private Connection conn;
    private int timeout = 20;
    private int maxRows = 100;
    private Thread worker;
    private final InputWrapper inputWrapper;
    private final ResultWrapper resultWrapper;
    private volatile boolean cancelRequest;
    private volatile boolean closeRequest;
    private int outputParameterPosition = -1;
    private boolean computeCount = false;
    private boolean check = true;
    private boolean isCsv = false;
    private Map<Integer, Object> statementParameters = new HashMap<Integer, Object>();

    public QueryExecutor(Query query, Map<String, QueryParameter> parameters, Map<String, Object> parameterValues, Connection conn, boolean computeCount, boolean check, boolean isCsv) throws QueryException {
        this.processIgnoreParameters(query, parameters, parameterValues);
        if (check) {
            this.checkInputs(query, parameters, parameterValues, conn);
        }
        this.query = query;
        this.conn = conn;
        this.parameterNames = query.parameterNames;
        this.parameters = parameters;
        this.parameterValues = parameterValues;
        this.computeCount = computeCount;
        this.check = check;
        this.isCsv = isCsv;
        this.inputWrapper = new InputWrapper();
        this.resultWrapper = new ResultWrapper();
        this.worker = new Thread((Runnable)this, this.getClass().getSimpleName());
        this.worker.start();
    }

    public QueryExecutor(Query query, Map<String, QueryParameter> parameters, Map<String, Object> parameterValues, Connection conn, boolean computeCount) throws QueryException {
        this(query, parameters, parameterValues, conn, computeCount, true, false);
    }

    public QueryExecutor(Query query, Map<String, QueryParameter> parameters, Map<String, Object> parameterValues, Connection conn) throws QueryException {
        this(query, parameters, parameterValues, conn, false);
    }

    public QueryExecutor(Query query, Connection conn) throws QueryException {
        this(query, new HashMap<String, QueryParameter>(), new HashMap<String, Object>(), conn);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized QueryResult execute() throws QueryException, InterruptedException {
        String queryString = this.createQueryString();
        PreparedStatement countPstmt = null;
        if (this.computeCount) {
            try {
                String countQueryString = "SELECT COUNT(*) FROM (" + queryString + ") A";
                if (this.isCsv) {
                    countQueryString = this.getCsvCountQuery(queryString);
                }
                countPstmt = this.createStatement(countQueryString);
                if (this.parameterNames.size() != 0) {
                    this.setParameterValues(countPstmt);
                }
            }
            catch (QueryException ex) {
                LOG.info((Object)("Cannot create count statement : " + ex.getMessage() + " .Will use rs.last()"));
                countPstmt = null;
            }
        }
        PreparedStatement pstmt = this.createStatement(queryString);
        if (this.parameterNames.size() != 0) {
            this.setParameterValues(pstmt);
        }
        try {
            this.setOutParametersValues(pstmt);
        }
        catch (SQLException e) {
            throw new QueryException(e);
        }
        catch (DialectException e) {
            throw new QueryException("Error set out parameter values for executing query : could not get dialect", e);
        }
        Object object = this.inputWrapper;
        synchronized (object) {
            this.inputWrapper.statement = pstmt;
            this.inputWrapper.countStatement = countPstmt;
            this.inputWrapper.query = queryString;
            this.inputWrapper.pending = true;
            this.inputWrapper.notify();
        }
        object = this.resultWrapper;
        synchronized (object) {
            try {
                while (!this.resultWrapper.serviced) {
                    this.resultWrapper.wait();
                }
                if (this.resultWrapper.exception != null) {
                    throw this.resultWrapper.exception;
                }
            }
            catch (InterruptedException e) {
                this.cancel();
                throw e;
            }
            finally {
                this.resultWrapper.serviced = false;
            }
            if (this.maxRows > 0 && this.resultWrapper.count > this.maxRows) {
                this.resultWrapper.count = this.maxRows;
            }
            this.closeRequest = true;
            InputWrapper inputWrapper = this.inputWrapper;
            synchronized (inputWrapper) {
                this.inputWrapper.pending = true;
                this.inputWrapper.notify();
            }
            return new QueryResult(this.resultWrapper.resultSet, this.resultWrapper.count, this.resultWrapper.executeTime);
        }
    }

    public void stop() {
        this.closeRequest = true;
        if (this.inputWrapper.countStatement != null || this.inputWrapper.statement != null) {
            this.cancel();
        }
        this.worker.interrupt();
        try {
            this.worker.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ResultSet resultSet = null;
        SQLException sqlException = null;
        int count = 0;
        while (!this.closeRequest) {
            long executeTime = 0L;
            Object object = this.inputWrapper;
            synchronized (object) {
                block33: {
                    block32: {
                        try {
                            while (!this.inputWrapper.pending) {
                                this.inputWrapper.wait();
                            }
                            this.inputWrapper.pending = false;
                            if (this.closeRequest) {
                                return;
                            }
                        }
                        catch (InterruptedException e) {
                            if (!this.closeRequest) break block32;
                            return;
                        }
                    }
                    try {
                        executeTime = System.currentTimeMillis();
                        Dialect dialect = null;
                        try {
                            dialect = DialectUtil.getDialect(this.conn);
                        }
                        catch (DialectException e) {
                            e.printStackTrace();
                            LOG.error((Object)e.getMessage(), (Throwable)e);
                        }
                        if (QueryUtil.isProcedureCall(this.query.getText())) {
                            resultSet = this.inputWrapper.statement.executeQuery();
                            if (dialect instanceof OracleDialect) {
                                resultSet = (ResultSet)((CallableStatement)this.inputWrapper.statement).getObject(this.outputParameterPosition);
                            }
                            count = -1;
                        } else {
                            count = -1;
                            boolean useLast = false;
                            if (this.inputWrapper.countStatement != null) {
                                ResultSet countResultSet = null;
                                try {
                                    countResultSet = this.inputWrapper.countStatement.executeQuery();
                                    countResultSet.next();
                                    count = countResultSet.getInt(1);
                                }
                                catch (SQLException e) {
                                    LOG.info((Object)("Cannot execute count statement : " + e.getMessage() + " .Will use rs.last()"));
                                    useLast = true;
                                }
                                finally {
                                    ConnectionUtil.closeStatement(this.inputWrapper.countStatement);
                                    ConnectionUtil.closeResultSet(countResultSet);
                                    this.inputWrapper.countStatement = null;
                                }
                            } else if (!this.cancelRequest) {
                                useLast = true;
                            }
                            if (!this.cancelRequest) {
                                resultSet = this.inputWrapper.statement.executeQuery();
                                if (useLast && !this.cancelRequest && this.computeCount) {
                                    if (dialect instanceof SQLiteDialect || dialect instanceof CSVDialect) {
                                        count = -1;
                                    } else {
                                        resultSet.last();
                                        count = resultSet.getRow();
                                        resultSet.beforeFirst();
                                    }
                                }
                            }
                        }
                        executeTime = System.currentTimeMillis() - executeTime;
                        this.logSql(executeTime);
                        this.statementParameters.clear();
                    }
                    catch (SQLException e) {
                        if (!this.cancelRequest) {
                            sqlException = e;
                        }
                    }
                    catch (Throwable t) {
                        LOG.error((Object)t.getMessage(), t);
                        if (this.cancelRequest) break block33;
                        sqlException = new SQLException("Execute query. See log for details");
                    }
                }
            }
            object = this.resultWrapper;
            synchronized (object) {
                this.resultWrapper.resultSet = resultSet;
                this.resultWrapper.count = count;
                this.resultWrapper.exception = sqlException == null ? null : new QueryException(sqlException);
                this.resultWrapper.serviced = true;
                this.resultWrapper.executeTime = executeTime;
                this.resultWrapper.notify();
            }
        }
    }

    private void checkInputs(Query query, Map<String, QueryParameter> parameters, Map<String, Object> parameterValues, Connection conn) throws QueryException {
        if (query == null || query.getText().trim().length() == 0) {
            throw new QueryException("query cannot be null");
        }
        if (conn == null) {
            throw new QueryException("database connection cannot be null");
        }
        Map<String, QueryParameter> map = ParameterUtil.getUsedParametersMap(query, parameters);
        for (String paramName : map.keySet()) {
            boolean hasSource;
            if (parameters == null || !parameters.containsKey(paramName)) {
                throw new QueryException("cannot find parameter definition for " + paramName);
            }
            if (parameterValues.containsKey(paramName)) continue;
            QueryParameter param = parameters.get(paramName);
            boolean hasDefaultSource = param.getDefaultSource() != null && !"".equals(param.getDefaultSource().trim());
            boolean bl = hasSource = param.getSource() != null && !"".equals(param.getSource().trim());
            if (hasDefaultSource) {
                try {
                    ParameterUtil.initDefaultParameterValues(conn, param, parameterValues);
                    continue;
                }
                catch (QueryException ex) {
                    LOG.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
            if (hasSource) {
                try {
                    ParameterUtil.initAllRuntimeParameterValues(conn, param, parameters, parameterValues);
                    continue;
                }
                catch (QueryException ex) {
                    LOG.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
            if (param.isHidden()) {
                ParameterUtil.initDefaultParameterValues(conn, param, parameterValues);
                continue;
            }
            throw new QueryException("cannot find parameter value for " + paramName);
        }
    }

    private PreparedStatement createStatement(String queryString) throws QueryException {
        PreparedStatement pstmt;
        try {
            int resultSetType;
            boolean hasScrollType = false;
            try {
                hasScrollType = DialectUtil.isSupportedResultSetType(this.conn, 1004);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
            int n = resultSetType = hasScrollType ? 1004 : 1003;
            if (QueryUtil.isProcedureCall(queryString)) {
                pstmt = this.conn.prepareCall("{" + queryString + "}", resultSetType, 1007);
            } else if (this.isCsv) {
                pstmt = this.conn.prepareStatement(queryString);
            } else {
                boolean keepCursorsOverCommit = false;
                try {
                    Dialect dialect = DialectUtil.getDialect(this.conn);
                    keepCursorsOverCommit = dialect.needsHoldCursorsForPreparedStatement();
                }
                catch (DialectException e) {
                    e.printStackTrace();
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                pstmt = keepCursorsOverCommit ? this.conn.prepareStatement(queryString, resultSetType, 1007, 1) : this.conn.prepareStatement(queryString, resultSetType, 1007);
            }
            try {
                pstmt.setQueryTimeout(this.timeout);
                pstmt.setMaxRows(this.maxRows);
            }
            catch (SQLException e) {
                LOG.warn((Object)e);
            }
        }
        catch (SQLException e) {
            throw new QueryException(e);
        }
        return pstmt;
    }

    private void setParameterValues(PreparedStatement pstmt) throws QueryException {
        try {
            QueryParameter parameter = null;
            String parameterName = null;
            Object parameterValue = null;
            int n = this.parameterNames.size();
            int i = 0;
            for (int j = 0; i < n && j < n; ++i, ++j) {
                parameterName = this.parameterNames.get(j);
                parameter = this.parameters.get(parameterName);
                parameterValue = this.parameterValues.get(parameterName);
                if ("Multiple".equals(parameter.getSelection())) {
                    Object[] multiParamValue = (Object[])parameterValue;
                    if (QueryUtil.isProcedureCall(this.query.getText())) {
                        int index = i;
                        if (this.outputParameterPosition != -1 && this.outputParameterPosition <= i + 1) {
                            index = i + 1;
                        }
                        StringBuilder sb = new StringBuilder();
                        for (int k = 0; k < multiParamValue.length; ++k) {
                            Object v = multiParamValue[k];
                            if (v instanceof IdName) {
                                v = ((IdName)v).getId();
                            } else if (v instanceof String) {
                                sb.append("'");
                            }
                            sb.append(v);
                            if (v instanceof String) {
                                sb.append("'");
                            }
                            if (k >= multiParamValue.length - 1) continue;
                            sb.append(",");
                        }
                        this.setParameterValue(pstmt, String.class, sb.toString(), index, true);
                        continue;
                    }
                    for (int k = 0; k < multiParamValue.length; ++k) {
                        this.setParameterValue(pstmt, parameter.getValueClass(), multiParamValue[k], i);
                        ++i;
                        ++n;
                    }
                    --i;
                    --n;
                    continue;
                }
                int index = i;
                if (QueryUtil.isProcedureCall(this.query.getText()) && this.outputParameterPosition != -1 && this.outputParameterPosition <= i + 1) {
                    index = i + 1;
                }
                this.setParameterValue(pstmt, parameter.getValueClass(), parameterValue, index);
            }
        }
        catch (SQLException e) {
            throw new QueryException("Error set parameter values for executing query", e);
        }
    }

    private void setOutParametersValues(PreparedStatement pstmt) throws SQLException, DialectException {
        Dialect dialect = DialectUtil.getDialect(this.conn);
        if (QueryUtil.isProcedureCall(this.query.getText()) && dialect.hasProcedureWithCursor()) {
            ((CallableStatement)pstmt).registerOutParameter(this.outputParameterPosition, dialect.getCursorSqlType());
        }
    }

    private void setParameterValue(PreparedStatement pstmt, Class paramValueClass, Object paramValue, int index) throws SQLException, QueryException {
        this.setParameterValue(pstmt, paramValueClass, paramValue, index, false);
    }

    private void setParameterValue(PreparedStatement pstmt, Class paramValueClass, Object paramValue, int index, boolean isProcedureMultiple) throws SQLException, QueryException {
        if ("__NULL__".equals(paramValue)) {
            paramValue = null;
        }
        if (isProcedureMultiple) {
            if (paramValue == null) {
                pstmt.setNull(index + 1, 12);
            } else {
                pstmt.setString(index + 1, (String)paramValue);
            }
        } else if (paramValueClass.equals(Object.class)) {
            if (paramValue == null) {
                pstmt.setNull(index + 1, 2000);
            } else if (paramValue instanceof IdName) {
                pstmt.setObject(index + 1, ((IdName)paramValue).getId());
            } else {
                pstmt.setObject(index + 1, paramValue);
            }
        } else if (paramValueClass.equals(Boolean.class)) {
            if (paramValue == null) {
                pstmt.setNull(index + 1, -7);
            } else if (paramValue instanceof IdName) {
                pstmt.setBoolean(index + 1, (Boolean)((IdName)paramValue).getId());
            } else {
                pstmt.setBoolean(index + 1, (Boolean)paramValue);
            }
        } else if (paramValueClass.equals(Byte.class)) {
            if (paramValue == null) {
                pstmt.setNull(index + 1, -6);
            } else if (paramValue instanceof IdName) {
                pstmt.setByte(index + 1, (Byte)((IdName)paramValue).getId());
            } else {
                pstmt.setByte(index + 1, (Byte)paramValue);
            }
        } else if (paramValueClass.equals(Double.class)) {
            if (paramValue == null) {
                pstmt.setNull(index + 1, 8);
            } else if (paramValue instanceof IdName) {
                pstmt.setDouble(index + 1, (Double)((IdName)paramValue).getId());
            } else {
                pstmt.setDouble(index + 1, (Double)paramValue);
            }
        } else if (paramValueClass.equals(Float.class)) {
            if (paramValue == null) {
                pstmt.setNull(index + 1, 6);
            } else if (paramValue instanceof IdName) {
                pstmt.setFloat(index + 1, ((Float)((IdName)paramValue).getId()).floatValue());
            } else {
                pstmt.setFloat(index + 1, ((Float)paramValue).floatValue());
            }
        } else if (paramValueClass.equals(Integer.class)) {
            if (paramValue == null) {
                pstmt.setNull(index + 1, 4);
            } else if (paramValue instanceof IdName) {
                pstmt.setObject(index + 1, ((IdName)paramValue).getId());
            } else {
                pstmt.setInt(index + 1, (Integer)paramValue);
            }
        } else if (paramValueClass.equals(Long.class)) {
            if (paramValue == null) {
                pstmt.setNull(index + 1, -5);
            } else if (paramValue instanceof IdName) {
                pstmt.setLong(index + 1, (Long)((IdName)paramValue).getId());
            } else {
                pstmt.setLong(index + 1, (Long)paramValue);
            }
        } else if (paramValueClass.equals(Short.class)) {
            if (paramValue == null) {
                pstmt.setNull(index + 1, 5);
            } else if (paramValue instanceof IdName) {
                pstmt.setShort(index + 1, (Short)((IdName)paramValue).getId());
            } else {
                pstmt.setShort(index + 1, (Short)paramValue);
            }
        } else if (paramValueClass.equals(BigDecimal.class)) {
            if (paramValue == null) {
                pstmt.setNull(index + 1, 3);
            } else if (paramValue instanceof IdName) {
                Serializable ser = ((IdName)paramValue).getId();
                if (ser instanceof BigDecimal) {
                    pstmt.setBigDecimal(index + 1, (BigDecimal)ser);
                } else {
                    pstmt.setInt(index + 1, (Integer)ser);
                }
            } else {
                pstmt.setObject(index + 1, paramValue);
            }
        } else if (paramValueClass.equals(BigInteger.class)) {
            if (paramValue == null) {
                pstmt.setNull(index + 1, -5);
            } else if (paramValue instanceof IdName) {
                Serializable ser = ((IdName)paramValue).getId();
                if (ser instanceof BigInteger) {
                    pstmt.setBigDecimal(index + 1, new BigDecimal((BigInteger)ser));
                } else if (ser instanceof BigDecimal) {
                    pstmt.setBigDecimal(index + 1, (BigDecimal)ser);
                } else {
                    pstmt.setInt(index + 1, (Integer)ser);
                }
            } else {
                pstmt.setObject(index + 1, paramValue);
            }
        } else if (paramValueClass.equals(String.class)) {
            if (paramValue == null) {
                pstmt.setNull(index + 1, 12);
            } else if (paramValue instanceof IdName) {
                if (((IdName)paramValue).getId() == null) {
                    pstmt.setNull(index + 1, 12);
                } else {
                    pstmt.setString(index + 1, ((IdName)paramValue).getId().toString());
                }
            } else {
                pstmt.setString(index + 1, paramValue.toString());
            }
        } else if (paramValueClass.equals(java.util.Date.class)) {
            if (paramValue == null) {
                pstmt.setNull(index + 1, 91);
            } else if (paramValue instanceof IdName) {
                java.util.Date date;
                Serializable obj = ((IdName)paramValue).getId();
                if (obj instanceof String) {
                    try {
                        date = IdNameRenderer.sdf.parse((String)((Object)obj));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                        date = new java.util.Date();
                    }
                } else {
                    date = (java.util.Date)obj;
                }
                pstmt.setDate(index + 1, new Date(date.getTime()));
            } else {
                pstmt.setDate(index + 1, new Date(((java.util.Date)paramValue).getTime()));
            }
        } else if (paramValueClass.equals(Timestamp.class)) {
            if (paramValue == null) {
                pstmt.setNull(index + 1, 93);
            } else if (paramValue instanceof IdName) {
                java.util.Date date;
                Serializable obj = ((IdName)paramValue).getId();
                if (obj instanceof String) {
                    try {
                        date = IdNameRenderer.sdf.parse((String)((Object)obj));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                        date = new java.util.Date();
                    }
                } else {
                    date = (java.util.Date)obj;
                }
                pstmt.setTimestamp(index + 1, new Timestamp(date.getTime()));
            } else {
                pstmt.setTimestamp(index + 1, new Timestamp(((java.util.Date)paramValue).getTime()));
            }
        } else if (paramValueClass.equals(Time.class)) {
            if (paramValue == null) {
                pstmt.setNull(index + 1, 92);
            } else if (paramValue instanceof IdName) {
                java.util.Date date;
                Serializable obj = ((IdName)paramValue).getId();
                if (obj instanceof String) {
                    try {
                        date = IdNameRenderer.sdf.parse((String)((Object)obj));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                        date = new java.util.Date();
                    }
                } else {
                    date = (java.util.Date)obj;
                }
                pstmt.setTime(index + 1, new Time(date.getTime()));
            } else {
                pstmt.setTime(index + 1, new Time(((java.util.Date)paramValue).getTime()));
            }
        } else {
            throw new QueryException("Parameter type " + paramValueClass.getName() + " not supported in query");
        }
        this.statementParameters.put(index, paramValue);
    }

    private String createQueryString() {
        QueryChunk[] chunks = this.query.getChunks();
        if (chunks == null || chunks.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        QueryChunk chunk = null;
        int position = 1;
        block4: for (int i = 0; i < chunks.length; ++i) {
            chunk = chunks[i];
            switch (chunk.getType()) {
                case 2: {
                    ++position;
                    String paramName = chunk.getText();
                    QueryParameter param = this.parameters.get(paramName);
                    if ("Multiple".equals(param.getSelection())) {
                        if (QueryUtil.isProcedureCall(this.query.getText())) {
                            sb.append("?");
                            continue block4;
                        }
                        Object[] paramValue = (Object[])this.parameterValues.get(paramName);
                        sb.append('(');
                        for (int j = 0; j < paramValue.length; ++j) {
                            if (j > 0) {
                                sb.append(',');
                            }
                            sb.append('?');
                        }
                        sb.append(')');
                        continue block4;
                    }
                    sb.append("?");
                    continue block4;
                }
                case 1: {
                    if (chunk.getText().contains("?")) {
                        this.outputParameterPosition = position;
                    }
                }
                default: {
                    sb.append(chunk.getText());
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel() {
        this.cancelRequest = true;
        try {
            if (this.inputWrapper.countStatement != null) {
                this.inputWrapper.countStatement.cancel();
            }
            this.inputWrapper.statement.cancel();
            ResultWrapper resultWrapper = this.resultWrapper;
            synchronized (resultWrapper) {
                while (!this.resultWrapper.serviced) {
                    this.resultWrapper.wait();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.cancelRequest = false;
        }
    }

    private void processIgnoreParameters(Query query, Map<String, QueryParameter> parameters, Map<String, Object> parameterValues) {
        ArrayList<String> ignoredList = new ArrayList<String>();
        if (parameters == null) {
            return;
        }
        Iterator<String> it = parameters.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next();
            QueryParameter param = parameters.get(name);
            if (!param.isIgnore()) continue;
            ignoredList.add("${" + name + "}");
            it.remove();
            parameterValues.remove(name);
        }
        if (ignoredList.size() == 0) {
            return;
        }
        String sql = StringUtil.deleteExcededSpaces(query.getText());
        HashSet<Integer> indexes = new HashSet<Integer>();
        HashSet<Integer> columns = new HashSet<Integer>();
        String[] words = sql.split("\\s");
        int size = words.length;
        for (int i = 0; i < size; ++i) {
            int pIndex = this.findIndex(words[i], ignoredList);
            if (pIndex == -1) continue;
            indexes.add(i);
            indexes.add(i - 1);
            indexes.add(i - 2);
            columns.add(i - 2);
            if (words[i - 1].equalsIgnoreCase(IN) || words[i - 1].equalsIgnoreCase(LIKE)) {
                if (!words[i - 2].equalsIgnoreCase(NOT)) continue;
                indexes.add(i - 3);
                continue;
            }
            if (words[i - 1].equalsIgnoreCase(AND)) {
                indexes.add(i - 3);
                indexes.add(i - 4);
                columns.remove(i - 2);
                continue;
            }
            if (!words[i - 1].equalsIgnoreCase(BETWEEN)) continue;
            indexes.add(i + 1);
            indexes.add(i + 2);
        }
        StringBuilder newSql = new StringBuilder();
        int size2 = words.length;
        for (int i = 0; i < size2; ++i) {
            boolean removed = false;
            for (Integer index : indexes) {
                if (!index.equals(i)) continue;
                removed = true;
            }
            if (!removed) {
                newSql.append(words[i]);
                if (i >= size2 - 1) continue;
                newSql.append(" ");
                continue;
            }
            if (!columns.contains(i)) continue;
            newSql.append(" 1 = 1 ");
        }
        query.setText(newSql.toString());
    }

    private int findIndex(String look, List<String> list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String s = list.get(i);
            if (!look.equalsIgnoreCase(s)) continue;
            return i;
        }
        return -1;
    }

    private void logSql(long time) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.inputWrapper.query);
        }
        if (LOG.isInfoEnabled()) {
            String preparedSql = this.inputWrapper.query;
            StringBuffer displayableSql = new StringBuffer(preparedSql.length());
            if (this.statementParameters != null) {
                int i = 0;
                int limit = 0;
                int base = 0;
                while ((limit = preparedSql.indexOf(63, limit)) != -1) {
                    displayableSql.append(preparedSql.substring(base, limit));
                    Object value = this.statementParameters.get(i);
                    if (value instanceof IdName) {
                        Serializable idName = ((IdName)value).getId();
                        if (idName instanceof String) {
                            displayableSql.append("'");
                            displayableSql.append(value);
                            displayableSql.append("'");
                        } else {
                            displayableSql.append(value);
                        }
                    } else if (value instanceof String) {
                        displayableSql.append("'");
                        displayableSql.append(value);
                        displayableSql.append("'");
                    } else if (value instanceof java.util.Date) {
                        displayableSql.append(SimpleDateFormat.getDateTimeInstance().format(value));
                    } else if (value == null) {
                        displayableSql.append("NULL");
                    } else {
                        displayableSql.append(value);
                    }
                    ++i;
                    base = ++limit;
                }
                if (base < preparedSql.length()) {
                    displayableSql.append(preparedSql.substring(base));
                }
            }
            LOG.info((Object)(displayableSql + " => (" + time + " ms)"));
        }
    }

    private String getCsvCountQuery(String query) {
        if (query == null) {
            return null;
        }
        int index = (query = query.toLowerCase()).indexOf("from");
        if (index == -1) {
            return null;
        }
        return "select count(*) from " + query.substring(index + 4);
    }

    class ResultWrapper {
        public ResultSet resultSet;
        public QueryException exception;
        public int count;
        public boolean serviced;
        public long executeTime;

        ResultWrapper() {
        }
    }

    class InputWrapper {
        public PreparedStatement statement;
        public PreparedStatement countStatement;
        public String query;
        public boolean pending;

        InputWrapper() {
        }
    }
}

