/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.queryexec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import ro.nextreports.engine.util.StringUtil;

public class QueryParameter
implements Serializable {
    private static final long serialVersionUID = -4076375031406410286L;
    public static final String INTEGER_VALUE = "java.lang.Integer";
    public static final String STRING_VALUE = "java.lang.String";
    public static final String BOOLEAN_VALUE = "java.lang.Boolean";
    public static final String BYTE_VALUE = "java.lang.Byte";
    public static final String DATE_VALUE = "java.util.Date";
    public static final String TIMESTAMP_VALUE = "java.sql.Timestamp";
    public static final String TIME_VALUE = "java.sql.Time";
    public static final String DOUBLE_VALUE = "java.lang.Double";
    public static final String FLOAT_VALUE = "java.lang.Float";
    public static final String LONG_VALUE = "java.lang.Long";
    public static final String SHORT_VALUE = "java.lang.Short";
    public static final String BIGDECIMAL_VALUE = "java.math.BigDecimal";
    public static final String BIGINTEGER_VALUE = "java.math.BigInteger";
    public static final String OBJECT_VALUE = "java.lang.Object";
    public static final String SINGLE_SELECTION = "Single";
    public static final String MULTIPLE_SELECTION = "Multiple";
    public static final byte NO_ORDER = -1;
    public static final byte ORDER_BY_SELECT = 0;
    public static final byte ORDER_BY_NAME = 1;
    public static final byte ORDER_BY_ID = 2;
    public static String INTERVAL_START_DATE_NAME = "start_date";
    public static String INTERVAL_END_DATE_NAME = "end_date";
    public static final String[] ALL_VALUES = new String[]{"java.lang.Integer", "java.lang.String", "java.lang.Boolean", "java.lang.Byte", "java.util.Date", "java.sql.Timestamp", "java.sql.Time", "java.lang.Double", "java.lang.Float", "java.lang.Long", "java.lang.Short", "java.math.BigDecimal", "java.math.BigInteger", "java.lang.Object"};
    public static final String[] SELECTIONS = new String[]{"Single", "Multiple"};
    protected String name;
    protected String runtimeName;
    protected String description;
    protected String valueClassName = "java.lang.String";
    protected transient Class valueClass;
    protected String source;
    protected String selection;
    protected boolean ignore;
    protected boolean mandatory;
    protected boolean manualSource;
    protected String schema;
    protected boolean isProcedureParameter;
    protected String previewValue;
    protected byte orderBy;
    protected ArrayList<Serializable> defaultValues;
    protected String defaultSource;
    protected boolean hidden;
    protected transient List values = new ArrayList();
    protected transient ArrayList<Serializable> defaultSourceValues;
    protected transient boolean subreportParameter = false;

    public QueryParameter(String name, String valueClassName) {
        this(name, "", valueClassName);
    }

    public QueryParameter(String name, String description, String valueClassName) {
        this.name = name;
        this.description = description;
        this.valueClassName = valueClassName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public void setRuntimeName(String runtimeName) {
        this.runtimeName = runtimeName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Class getValueClass() {
        if (this.valueClass == null && this.valueClassName != null) {
            try {
                this.valueClass = Class.forName(this.valueClassName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.valueClass;
    }

    public String getValueClassName() {
        return this.valueClassName;
    }

    public String getSelection() {
        return this.selection;
    }

    public void setSelection(String selection) {
        this.selection = selection;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public List getValues() {
        return this.values;
    }

    public void setValues(List values) {
        this.values = values;
    }

    public ArrayList<Serializable> getDefaultValues() {
        return this.defaultValues;
    }

    public void setDefaultValues(ArrayList<Serializable> defaultValues) {
        this.defaultValues = defaultValues;
    }

    public String getDefaultSource() {
        return this.defaultSource;
    }

    public void setDefaultSource(String defaultSource) {
        this.defaultSource = defaultSource;
    }

    public ArrayList<Serializable> getDefaultSourceValues() {
        return this.defaultSourceValues;
    }

    public void setDefaultSourceValues(ArrayList<Serializable> defaultSourceValues) {
        this.defaultSourceValues = defaultSourceValues;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isManualSource() {
        return this.manualSource;
    }

    public void setManualSource(boolean manualSource) {
        this.manualSource = manualSource;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean isProcedureParameter() {
        return this.isProcedureParameter;
    }

    public void setProcedureParameter(boolean procedureParameter) {
        this.isProcedureParameter = procedureParameter;
    }

    public String getPreviewValue() {
        return this.previewValue;
    }

    public void setPreviewValue(String previewValue) {
        if (!this.isProcedureParameter && previewValue != null) {
            throw new IllegalArgumentException("Parameter '" + this.name + "' is not a procedure parameter.");
        }
        this.previewValue = previewValue;
    }

    public byte getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(byte orderBy) {
        this.orderBy = orderBy;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isDependent() {
        return this.isManualSource() && this.source.contains("${");
    }

    public List<String> getDependentParameterNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.isDependent()) {
            String chunk = this.source;
            int start = chunk.indexOf("${");
            while (start != -1) {
                int end = chunk.indexOf("}");
                String paramName = chunk.substring(start + 2, end);
                names.add(paramName);
                if (end == chunk.length() - 1) {
                    start = -1;
                    continue;
                }
                chunk = chunk.substring(end + 1);
                start = chunk.indexOf("${");
            }
        }
        return names;
    }

    public boolean isSubreportParameter() {
        return this.subreportParameter;
    }

    public void setSubreportParameter(boolean subreportParameter) {
        this.subreportParameter = subreportParameter;
    }

    public boolean equals(Object o) {
        if (!this.basicEquals(o)) {
            return false;
        }
        QueryParameter that = (QueryParameter)o;
        if (this.ignore != that.ignore) {
            return false;
        }
        if (this.mandatory != that.mandatory) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.runtimeName != null ? !this.runtimeName.equals(that.runtimeName) : that.runtimeName != null) {
            return false;
        }
        if (this.schema != null ? !this.schema.equals(that.schema) : that.schema != null) {
            return false;
        }
        if (this.orderBy != that.getOrderBy()) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        return !(this.defaultSource != null ? !this.defaultSource.equals(that.defaultSource) : that.defaultSource != null);
    }

    private boolean basicEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryParameter that = (QueryParameter)o;
        if (this.manualSource != that.manualSource) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.selection != null ? !this.selection.equals(that.selection) : that.selection != null) {
            return false;
        }
        if (this.valueClassName != null ? !this.valueClassName.equals(that.valueClassName) : that.valueClassName != null) {
            return false;
        }
        if (this.isProcedureParameter != that.isProcedureParameter) {
            return false;
        }
        if (this.previewValue != null ? !this.previewValue.equals(that.previewValue) : that.previewValue != null) {
            return false;
        }
        if (!(this.defaultValues == null || that.defaultValues == null || this.defaultValues.containsAll(that.defaultValues) && that.defaultValues.containsAll(this.defaultValues))) {
            return false;
        }
        return this.hidden == that.hidden;
    }

    public boolean compare(Object o) {
        if (!this.basicEquals(o)) {
            return false;
        }
        QueryParameter that = (QueryParameter)o;
        if (!StringUtil.equalsText(this.source, that.source)) {
            return false;
        }
        return StringUtil.equalsText(this.defaultSource, that.defaultSource);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.runtimeName != null ? this.runtimeName.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.valueClassName != null ? this.valueClassName.hashCode() : 0);
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.selection != null ? this.selection.hashCode() : 0);
        result = 31 * result + (this.ignore ? 1 : 0);
        result = 31 * result + (this.mandatory ? 1 : 0);
        result = 31 * result + (this.manualSource ? 1 : 0);
        result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
        result = 31 * result + (this.isProcedureParameter ? 1 : 0);
        result = 31 * result + (this.previewValue != null ? this.previewValue.hashCode() : 0);
        result = 31 * result + this.orderBy;
        result = 31 * result + (this.defaultValues != null ? this.defaultValues.hashCode() : 0);
        result = 31 * result + (this.defaultSource != null ? this.defaultSource.hashCode() : 0);
        result = 31 * result + (this.hidden ? 1 : 0);
        return result;
    }

    public String toString() {
        return "QueryParameter{name='" + this.name + '\'' + ", runtimeName='" + this.runtimeName + '\'' + ", description='" + this.description + '\'' + ", valueClassName='" + this.valueClassName + '\'' + ", source='" + this.source + '\'' + ", selection='" + this.selection + '\'' + ", ignore=" + this.ignore + ", mandatory=" + this.mandatory + ", manualSource=" + this.manualSource + ", schema='" + this.schema + '\'' + ", isProcedureParameter=" + this.isProcedureParameter + ", previewValue='" + this.previewValue + '\'' + ", orderBy=" + this.orderBy + ", hidden=" + this.hidden + ", defaultValues=" + this.defaultValues + ", defaultSource=" + this.defaultSource + ", defaultSourceValues=" + this.defaultSourceValues + '}';
    }
}

