/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.queryexec;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import ro.nextreports.engine.queryexec.QueryException;

public class QueryResult {
    private ResultSet resultSet;
    private int numberOfRows;
    private int numberOfColumns;
    private long executeTime;
    private Map<Integer, String> columnNames;
    private Map<String, Integer> columnIndexes;
    private Map<Integer, String> columnClassNames;
    private Map<Integer, Integer> columnTypes;

    public QueryResult(ResultSet rs, int count, long executeTime) throws QueryException {
        this.resultSet = rs;
        this.executeTime = executeTime;
        this.numberOfRows = count;
        this.initCache();
    }

    private void initCache() throws QueryException {
        this.columnNames = new HashMap<Integer, String>();
        this.columnIndexes = new HashMap<String, Integer>();
        this.columnClassNames = new HashMap<Integer, String>();
        this.columnTypes = new HashMap<Integer, Integer>();
        try {
            ResultSetMetaData metadata = this.resultSet.getMetaData();
            this.numberOfColumns = metadata.getColumnCount();
            for (int i = 0; i < this.numberOfColumns; ++i) {
                this.columnNames.put(i, metadata.getColumnLabel(i + 1));
                this.columnIndexes.put(metadata.getColumnLabel(i + 1), i);
                this.columnClassNames.put(i, metadata.getColumnClassName(i + 1));
                this.columnTypes.put(i, metadata.getColumnType(i + 1));
            }
        }
        catch (SQLException e) {
            throw new QueryException(e);
        }
    }

    public boolean hasNext() throws QueryException {
        if (this.resultSet == null) {
            return false;
        }
        try {
            return this.resultSet.next();
        }
        catch (SQLException e) {
            throw new QueryException(e);
        }
    }

    public Object nextValue(String columnName) throws QueryException {
        if (this.resultSet == null) {
            return null;
        }
        try {
            return this.resultSet.getObject(columnName);
        }
        catch (SQLException e) {
            throw new QueryException(e);
        }
    }

    public Object nextBlobValue(String columnName) throws QueryException {
        if (this.resultSet == null) {
            return null;
        }
        try {
            return this.resultSet.getBlob(columnName);
        }
        catch (SQLException e) {
            throw new QueryException(e);
        }
    }

    public Object nextValue(int columnIndex) throws QueryException {
        if (this.resultSet == null) {
            return null;
        }
        try {
            return this.resultSet.getObject(columnIndex + 1);
        }
        catch (SQLException e) {
            throw new QueryException(e);
        }
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public int getColumnCount() {
        return this.numberOfColumns;
    }

    public int getRowCount() {
        return this.numberOfRows;
    }

    public String getColumnName(int columnIndex) {
        return this.columnNames.get(columnIndex);
    }

    public int getColumnIndex(String columnName) {
        return this.columnIndexes.get(columnName);
    }

    public String getColumnClassName(int columnIndex) {
        return this.columnClassNames.get(columnIndex);
    }

    public int getColumnType(int columnIndex) {
        return this.columnTypes.get(columnIndex);
    }

    public int getColumnType(String columnName) {
        return this.getColumnType(this.getColumnIndex(columnName));
    }

    public Object getValueAt(int rowIndex, int columnIndex) throws QueryException {
        if (this.resultSet == null) {
            return null;
        }
        try {
            int row = this.resultSet.getRow();
            this.resultSet.absolute(rowIndex + 1);
            Object object = this.resultSet.getObject(columnIndex + 1);
            if (row == 0) {
                this.resultSet.beforeFirst();
            } else {
                this.resultSet.absolute(row);
            }
            return object;
        }
        catch (SQLException e) {
            throw new QueryException(e);
        }
    }

    public Object getValueAt(int rowIndex, String columnName) throws QueryException {
        if (this.resultSet == null) {
            return null;
        }
        try {
            int row = this.resultSet.getRow();
            this.resultSet.absolute(rowIndex + 1);
            Object object = this.resultSet.getObject(columnName);
            if (row == 0) {
                this.resultSet.beforeFirst();
            } else {
                this.resultSet.absolute(row);
            }
            return object;
        }
        catch (SQLException e) {
            throw new QueryException(e);
        }
    }

    public long getExecuteTime() {
        return this.executeTime;
    }

    public void close() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isEmpty() {
        try {
            if (!this.resultSet.isBeforeFirst()) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }
}

