/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.queryexec.demo;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import ro.nextreports.engine.queryexec.Query;
import ro.nextreports.engine.queryexec.QueryExecutor;
import ro.nextreports.engine.queryexec.QueryParameter;
import ro.nextreports.engine.queryexec.QueryResult;
import ro.nextreports.engine.queryexec.util.QueryResultPrinter;
import ro.nextreports.engine.queryexec.util.SqlFile;
import ro.nextreports.engine.queryexec.util.StringUtil;

public class QueryExecDemo {
    private static Connection conn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try (QueryResult result = null;){
            SqlFile sqlFile = new SqlFile("demo.sql");
            String sql = sqlFile.getSqlList().get(0);
            System.out.println("=== sql ===");
            System.out.println(sql);
            sql = QueryExecDemo.format(sql);
            System.out.println();
            System.out.println("=== sql after format ===");
            System.out.println(sql);
            Query query = new Query(sql);
            String[] parameterNames = query.getParameterNames();
            QueryExecDemo.printParameterNames(parameterNames);
            Connection conn = QueryExecDemo.getConnection();
            HashMap<String, QueryParameter> parameters = new HashMap<String, QueryParameter>();
            QueryParameter param = new QueryParameter("name", "", "java.lang.String");
            parameters.put(param.getName(), param);
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put(param.getName(), "M%");
            QueryExecutor executor = new QueryExecutor(query, parameters, values, conn);
            result = executor.execute();
            System.out.println("columns = " + result.getColumnCount());
            QueryResultPrinter.printResult(result);
        }
    }

    private static void printParameterNames(String[] parametersNames) {
        System.out.println("Parmaeter names:");
        for (int i = 0; i < parametersNames.length; ++i) {
            System.out.println(parametersNames[i]);
        }
    }

    private static String format(String sql) {
        sql = StringUtil.stripSingleLineComments(sql);
        sql = StringUtil.stripMultiLineComments(sql);
        sql = StringUtil.stripBlankLines(sql);
        sql = StringUtil.trimLines(sql);
        sql = StringUtil.replaceTabsWithSpaces(sql, 1);
        sql = StringUtil.stripNewlines(sql);
        return sql;
    }

    private static Connection getConnection() throws Exception {
        if (conn == null) {
            String driverName = "oracle.jdbc.driver.OracleDriver";
            Class.forName(driverName);
            String serverName = "192.168.12.14";
            String portNumber = "1521";
            String sid = "dev1";
            String url = "jdbc:oracle:thin:@" + serverName + ":" + portNumber + ":" + sid;
            String username = "misdev1";
            String password = "misdev1";
            conn = DriverManager.getConnection(url, username, password);
        }
        return conn;
    }
}

