/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.queryexec.demo;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import ro.nextreports.engine.queryexec.Query;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.queryexec.QueryResult;

public class SimpleQueryExecutor
implements Runnable {
    public static final int DEFAULT_TIMEOUT = 20;
    public static final int DEFAULT_MAX_ROWS = 100;
    private Query query;
    private Connection conn;
    private Thread worker;
    private final InputWrapper inputWrapper;
    private final ResultWrapper resultWrapper;
    private volatile boolean cancelRequest;
    private volatile boolean closeRequest;

    public SimpleQueryExecutor(Query query, Connection conn) {
        this.query = query;
        this.conn = conn;
        this.inputWrapper = new InputWrapper();
        this.resultWrapper = new ResultWrapper();
        this.worker = new Thread(this);
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized QueryResult execute() throws QueryException, InterruptedException {
        String queryString = this.query.getText();
        System.out.println("queryString = " + queryString);
        String countQueryString = "SELECT COUNT(*) FROM (" + queryString + ")";
        Object object = this.inputWrapper;
        synchronized (object) {
            try {
                this.inputWrapper.statement = this.conn.createStatement();
            }
            catch (SQLException e) {
                e.printStackTrace();
                return null;
            }
            this.inputWrapper.query = queryString;
            try {
                this.inputWrapper.countStatement = this.conn.createStatement();
            }
            catch (SQLException e) {
                e.printStackTrace();
                return null;
            }
            this.inputWrapper.countQuery = countQueryString;
            this.inputWrapper.pending = true;
            this.inputWrapper.notify();
        }
        object = this.resultWrapper;
        synchronized (object) {
            try {
                while (!this.resultWrapper.serviced) {
                    this.resultWrapper.wait();
                }
                if (this.resultWrapper.exception != null) {
                    throw this.resultWrapper.exception;
                }
            }
            catch (InterruptedException e) {
                this.cancel();
                throw e;
            }
            finally {
                this.resultWrapper.serviced = false;
            }
            return new QueryResult(this.resultWrapper.resultSet, this.resultWrapper.count, this.resultWrapper.executeTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel() {
        this.cancelRequest = true;
        try {
            System.out.println("### Cancel start ...");
            this.inputWrapper.statement.cancel();
            System.out.println("### Cancel stop.");
            ResultWrapper resultWrapper = this.resultWrapper;
            synchronized (resultWrapper) {
                while (!this.resultWrapper.serviced) {
                    this.resultWrapper.wait();
                }
            }
        }
        catch (SQLException e) {
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.cancelRequest = false;
        }
    }

    public void stop() {
        this.closeRequest = true;
        if (this.inputWrapper.statement != null) {
            this.cancel();
        }
        this.worker.interrupt();
        try {
            this.worker.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ResultSet resultSet = null;
        SQLException sqlException = null;
        int count = 0;
        while (!this.closeRequest) {
            long executeTime = 0L;
            Object object = this.inputWrapper;
            synchronized (object) {
                block13: {
                    block12: {
                        try {
                            while (!this.inputWrapper.pending) {
                                this.inputWrapper.wait();
                            }
                            this.inputWrapper.pending = false;
                        }
                        catch (InterruptedException e) {
                            if (!this.closeRequest) break block12;
                            return;
                        }
                    }
                    try {
                        executeTime = System.currentTimeMillis();
                        System.out.println(">> query = " + this.inputWrapper.query);
                        resultSet = this.inputWrapper.statement.executeQuery(this.inputWrapper.query);
                        System.out.println(">> countQuery = " + this.inputWrapper.countQuery);
                        ResultSet countResultSet = this.inputWrapper.countStatement.executeQuery(this.inputWrapper.countQuery);
                        countResultSet.next();
                        count = countResultSet.getInt(1);
                        System.out.println(">>HERE count=" + count);
                        executeTime = System.currentTimeMillis() - executeTime;
                    }
                    catch (SQLException e) {
                        if (this.cancelRequest) break block13;
                        sqlException = e;
                    }
                }
            }
            object = this.resultWrapper;
            synchronized (object) {
                this.resultWrapper.resultSet = resultSet;
                this.resultWrapper.count = count;
                this.resultWrapper.exception = sqlException == null ? null : new QueryException(sqlException);
                this.resultWrapper.serviced = true;
                this.resultWrapper.executeTime = executeTime;
                this.resultWrapper.notify();
            }
        }
    }

    class ResultWrapper {
        public ResultSet resultSet;
        public int count;
        public QueryException exception;
        public boolean serviced;
        public long executeTime;

        ResultWrapper() {
        }
    }

    class InputWrapper {
        public Statement statement;
        public Statement countStatement;
        public String query;
        public String countQuery;
        public boolean pending;

        InputWrapper() {
        }
    }
}

