/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.queryexec.util;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.queryexec.QueryResult;

public class QueryResultPrinter {
    public static void printResult(QueryResult result) throws QueryException {
        QueryResultPrinter.printResult(result, System.out);
    }

    public static void printResult(QueryResult result, OutputStream output) throws QueryException {
        int i;
        int i2;
        int numcols;
        ResultSetMetaData metadata;
        PrintWriter out = new PrintWriter(new OutputStreamWriter(output));
        try {
            metadata = result.getResultSet().getMetaData();
        }
        catch (SQLException e) {
            throw new QueryException(e);
        }
        try {
            numcols = metadata.getColumnCount();
        }
        catch (SQLException e) {
            throw new QueryException(e);
        }
        String[] labels = new String[numcols];
        int[] colwidths = new int[numcols];
        int[] colpos = new int[numcols];
        int linewidth = 1;
        for (int i3 = 0; i3 < numcols; ++i3) {
            int labelsize;
            int size;
            colpos[i3] = linewidth;
            try {
                labels[i3] = metadata.getColumnLabel(i3 + 1);
                size = metadata.getColumnDisplaySize(i3 + 1);
            }
            catch (SQLException e) {
                throw new QueryException(e);
            }
            if (size == -1) {
                size = 30;
            }
            if ((labelsize = labels[i3].length()) > size) {
                size = labelsize;
            }
            colwidths[i3] = size + 1;
            linewidth += colwidths[i3] + 2;
        }
        StringBuffer divider = new StringBuffer(linewidth);
        StringBuffer blankline = new StringBuffer(linewidth);
        for (i2 = 0; i2 < linewidth; ++i2) {
            divider.insert(i2, '-');
            blankline.insert(i2, " ");
        }
        for (i2 = 0; i2 < numcols; ++i2) {
            divider.setCharAt(colpos[i2] - 1, '+');
        }
        divider.setCharAt(linewidth - 1, '+');
        out.println(divider);
        StringBuffer line = new StringBuffer(blankline.toString());
        line.setCharAt(0, '|');
        for (i = 0; i < numcols; ++i) {
            int pos = colpos[i] + 1 + (colwidths[i] - labels[i].length()) / 2;
            QueryResultPrinter.overwrite(line, pos, labels[i]);
            QueryResultPrinter.overwrite(line, colpos[i] + colwidths[i], " |");
        }
        out.println(line);
        out.println(divider);
        while (result.hasNext()) {
            line = new StringBuffer(blankline.toString());
            line.setCharAt(0, '|');
            for (i = 0; i < numcols; ++i) {
                Object value = result.nextValue(i + 1);
                if (value != null) {
                    QueryResultPrinter.overwrite(line, colpos[i] + 1, value.toString().trim());
                }
                QueryResultPrinter.overwrite(line, colpos[i] + colwidths[i], " |");
            }
            out.println(line);
        }
        out.println(divider);
        out.flush();
    }

    static void overwrite(StringBuffer sb, int pos, String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            sb.setCharAt(pos + i, s.charAt(i));
        }
    }
}

