/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.queryexec.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class StringUtil {
    private static final String SPACE = " ";
    private static final String COMMENT_MULTILINE_START = "/*";
    private static final String COMMENT_MULTILINE_END = "*/";
    private static final String COMMENT_SINGLELINE_START = "//";

    public static String stripBlankLines(String text) {
        if (text == null) {
            return null;
        }
        try {
            String line;
            StringBuffer output = new StringBuffer();
            BufferedReader in = new BufferedReader(new StringReader(text));
            boolean doneOneLine = false;
            while ((line = in.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                output.append(line);
                output.append('\n');
                doneOneLine = true;
            }
            if (!doneOneLine) {
                output.append('\n');
            }
            return output.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String stripNewlines(String text) {
        if (text == null) {
            return null;
        }
        try {
            String line;
            StringBuffer output = new StringBuffer();
            BufferedReader in = new BufferedReader(new StringReader(text));
            while ((line = in.readLine()) != null) {
                output.append(line);
                output.append(SPACE);
            }
            output.append('\n');
            return output.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String stripMultiLineComments(String text) {
        if (text == null) {
            return null;
        }
        try {
            String line;
            StringBuffer output = new StringBuffer();
            boolean inMultiLine = false;
            BufferedReader in = new BufferedReader(new StringReader(text));
            while ((line = in.readLine()) != null) {
                if (!inMultiLine) {
                    int cstart = line.indexOf(COMMENT_MULTILINE_START);
                    if (cstart >= 0) {
                        int cend = line.indexOf(COMMENT_MULTILINE_END, cstart + COMMENT_MULTILINE_START.length());
                        if (cend >= 0) {
                            line = line.substring(0, cstart) + SPACE + line.substring(cend + COMMENT_MULTILINE_END.length());
                        } else {
                            inMultiLine = true;
                            line = line.substring(0, cstart) + SPACE;
                        }
                    }
                } else {
                    int cend = line.indexOf(COMMENT_MULTILINE_END);
                    if (cend >= 0) {
                        line = line.substring(cend + COMMENT_MULTILINE_END.length());
                        inMultiLine = false;
                    } else {
                        line = SPACE;
                    }
                }
                output.append(line);
                output.append('\n');
            }
            return output.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String stripSingleLineComments(String text) {
        if (text == null) {
            return null;
        }
        try {
            String line;
            StringBuffer output = new StringBuffer();
            BufferedReader in = new BufferedReader(new StringReader(text));
            while ((line = in.readLine()) != null) {
                int cstart = line.indexOf(COMMENT_SINGLELINE_START);
                if (cstart >= 0) {
                    line = line.substring(0, cstart);
                }
                output.append(line);
                output.append('\n');
            }
            return output.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String trimLines(String text) {
        if (text == null) {
            return null;
        }
        try {
            String line;
            StringBuffer output = new StringBuffer();
            BufferedReader in = new BufferedReader(new StringReader(text));
            while ((line = in.readLine()) != null) {
                output.append(line.trim());
                output.append('\n');
            }
            return output.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String replaceTabsWithSpaces(String text, int tabSize) {
        String tabText = "";
        for (int i = 0; i < tabSize; ++i) {
            tabText = tabText + SPACE;
        }
        return text.replaceAll("\t", SPACE);
    }

    public static String deleteExcededSpaces(String text) {
        int size = text.length();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            char ch = text.charAt(i);
            if (ch == ' ') {
                char ch2;
                if (i <= 0 || (ch2 = text.charAt(i - 1)) == ' ' || i >= size - 1 || text.substring(i + 1).trim().equals("")) continue;
                sb.append(ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

