/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.util;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    private DateUtil() {
    }

    public static boolean after(Date d1, Date d2) {
        d1 = DateUtil.floor(d1);
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d1);
        d2 = DateUtil.floor(d2);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(d2);
        return c1.after(c2);
    }

    public static boolean before(Date d1, Date d2) {
        d1 = DateUtil.floor(d1);
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d1);
        d2 = DateUtil.floor(d2);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(d2);
        return c1.before(c2);
    }

    public static int compare(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d1);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(d2);
        if (c1.get(1) == c2.get(1)) {
            if (c1.get(2) == c2.get(2)) {
                return c1.get(5) - c2.get(5);
            }
            return c1.get(2) - c2.get(2);
        }
        return c1.get(1) - c2.get(1);
    }

    public static int getYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(1);
    }

    public static int getMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(2);
    }

    public static int getDayOfYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(6);
    }

    public static int getDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5);
    }

    public static int getDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(7);
    }

    public static int getHour(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(11);
    }

    public static int getMinute(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(12);
    }

    public static int getSecond(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(13);
    }

    public static Date floor(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date ceil(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }

    public static boolean sameDay(Date dateOne, Date dateTwo) {
        if (dateOne == null || dateTwo == null) {
            return false;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateOne);
        int year = cal.get(1);
        int day = cal.get(6);
        cal.setTime(dateTwo);
        int year2 = cal.get(1);
        int day2 = cal.get(6);
        return year == year2 && day == day2;
    }

    public static boolean sameWeek(Date dateOne, Date dateTwo) {
        if (dateOne == null || dateTwo == null) {
            return false;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateOne);
        int year = cal.get(1);
        int week = cal.get(3);
        cal.setTime(dateTwo);
        int year2 = cal.get(1);
        int week2 = cal.get(3);
        return year == year2 && week == week2;
    }

    public static boolean sameMonth(Date dateOne, Date dateTwo) {
        if (dateOne == null || dateTwo == null) {
            return false;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateOne);
        int year = cal.get(1);
        int month = cal.get(2);
        cal.setTime(dateTwo);
        int year2 = cal.get(1);
        int month2 = cal.get(2);
        return year == year2 && month == month2;
    }

    public static boolean sameHour(Date dateOne, Date dateTwo) {
        if (dateOne == null || dateTwo == null) {
            return false;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateOne);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(6);
        int hour = cal.get(11);
        cal.setTime(dateTwo);
        int year2 = cal.get(1);
        int month2 = cal.get(2);
        int day2 = cal.get(6);
        int hour2 = cal.get(11);
        return year == year2 && month == month2 && day == day2 && hour == hour2;
    }

    public static int getNumberOfDays(Date first, Date second) {
        Calendar c = Calendar.getInstance();
        int result = 0;
        int compare = first.compareTo(second);
        if (compare > 0) {
            return 0;
        }
        if (compare == 0) {
            return 1;
        }
        c.setTime(first);
        int firstDay = c.get(6);
        int firstYear = c.get(1);
        int firstDays = c.getActualMaximum(6);
        c.setTime(second);
        int secondDay = c.get(6);
        int secondYear = c.get(1);
        if (firstYear == secondYear) {
            result = secondDay - firstDay + 1;
        } else {
            result += firstDays - firstDay + 1;
            for (int i = firstYear + 1; i < secondYear; ++i) {
                c.set(i, 0, 0);
                result += c.getActualMaximum(6);
            }
            result += secondDay;
        }
        return result;
    }

    public static int[] getElapsedTime(Date first, Date second) {
        if (first.compareTo(second) == 1) {
            return null;
        }
        int difDays = 0;
        int difHours = 0;
        int difMinutes = 0;
        Calendar c = Calendar.getInstance();
        c.setTime(first);
        int h1 = c.get(11);
        int m1 = c.get(12);
        c.setTime(second);
        int h2 = c.get(11);
        int m2 = c.get(12);
        if (DateUtil.sameDay(first, second)) {
            difHours = h2 - h1;
        } else {
            difDays = DateUtil.getNumberOfDays(first, second) - 1;
            if (h1 >= h2) {
                --difDays;
                difHours = 24 - h1 + h2;
            } else {
                difHours = h2 - h1;
            }
        }
        difMinutes = m1 >= m2 ? 60 - m1 + m2 : m2 - m1;
        int[] result = new int[]{difDays, --difHours, difMinutes};
        return result;
    }

    public static Date addMinutes(Date d, int minutes) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(12, minutes);
        return cal.getTime();
    }

    public static Date setMinutes(Date d, int minutes) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(12, minutes);
        return cal.getTime();
    }

    public static Date addHours(Date d, int hours) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(11, hours);
        return cal.getTime();
    }

    public static Date setHours(Date d, int hours) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(11, hours);
        return cal.getTime();
    }

    public static Date addDays(Date d, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(6, days);
        return cal.getTime();
    }

    public static Date addWeeks(Date d, int weeks) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(3, weeks);
        return cal.getTime();
    }

    public static Date addMonths(Date d, int months) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(2, months);
        return cal.getTime();
    }

    public static int getLastDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getActualMaximum(5);
    }

    public static Date getFromTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new Date(timestamp.getTime());
    }

    public static Date getFirstDayFromLastWeek(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(3, -1);
        cal.set(7, 2);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getLastDayFromLastWeek(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        if (cal.getFirstDayOfWeek() == 2) {
            cal.add(3, -1);
        }
        cal.set(7, 1);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date getFirstDayFromCurrentWeek(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(7, 2);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getLastDayFromCurrentWeek(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        if (cal.getFirstDayOfWeek() == 1) {
            cal.add(3, 1);
        }
        cal.set(7, 1);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date getFirstDayFromLastMonth(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(2, -1);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getLastDayFromLastMonth(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(2, -1);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date getFirstDayFromCurrentMonth(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getLastDayFromCurrentMonth(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date getFirstDayFromLastYear(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(1, -1);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getLastDayFromLastYear(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(1, -1);
        cal.set(2, 11);
        cal.set(5, 31);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date getFirstDayFromCurrentYear(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getLastDayFromCurrentYear(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(2, 11);
        cal.set(5, 31);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date getLastNDay(Date d, int n, int unitType) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(unitType, -n);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }
}

