/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import ro.nextreports.engine.querybuilder.sql.dialect.Dialect;
import ro.nextreports.engine.querybuilder.sql.dialect.DialectException;
import ro.nextreports.engine.querybuilder.sql.dialect.DialectFactory;

public class DialectUtil {
    public static Dialect getDialect(Connection connection) throws SQLException, DialectException {
        DatabaseMetaData dbmd = connection.getMetaData();
        String dbName = dbmd.getDatabaseProductName();
        String dbVersion = dbmd.getDatabaseProductVersion();
        return DialectFactory.determineDialect(dbName, dbVersion);
    }

    public static boolean isSupportedResultSetType(Connection connection, int resultSetType) throws SQLException {
        DatabaseMetaData dbmd = connection.getMetaData();
        return dbmd.supportsResultSetType(resultSetType);
    }

    public static String getFullColumnClassName(String className) {
        if (className.startsWith("java.")) {
            return className;
        }
        if ("String".equals(className)) {
            return "java.lang.String";
        }
        if ("Int".equals(className)) {
            return "java.lang.Integer";
        }
        if ("Double".equals(className)) {
            return "java.lang.Double";
        }
        if ("Date".equals(className)) {
            return "java.util.Date";
        }
        if ("Long".equals(className)) {
            return "java.lang.Long";
        }
        if ("Float".equals(className)) {
            return "java.lang.Float";
        }
        if ("Boolean".equals(className)) {
            return "java.lang.Boolean";
        }
        return "java.lang.Object";
    }
}

