/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.util;

import com.lowagie.text.FontFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ro.nextreports.engine.util.OS;

public class FontUtil {
    private static Log LOG = LogFactory.getLog(FontUtil.class);

    public static void registerFonts(String ... dirs) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(dirs));
        set.addAll(FontUtil.getDefaultFontDirectories());
        for (String dir : set) {
            if (!new File(dir).exists()) continue;
            FontFactory.registerDirectory((String)dir);
            LOG.debug((Object)("Register font directory : " + dir));
        }
    }

    private static List<String> getDefaultFontDirectories() {
        String osname = System.getProperty("os.name");
        if (OS.isWindows()) {
            return FontUtil.getDefaultWindowFontDirectories();
        }
        if (OS.isLinux()) {
            return FontUtil.getDefaultLinuxFontDirectories();
        }
        return new ArrayList<String>();
    }

    private static List<String> getDefaultWindowFontDirectories() {
        ArrayList<String> result = new ArrayList<String>();
        String windirs = System.getProperty("java.library.path");
        String fs = System.getProperty("file.separator");
        if (windirs != null) {
            StringTokenizer strtok = new StringTokenizer(windirs, System.getProperty("path.separator"));
            while (strtok.hasMoreTokens()) {
                String token = strtok.nextToken();
                if (!token.toLowerCase().endsWith("system32")) continue;
                int lastBackslash = token.lastIndexOf(fs);
                result.add(token.substring(0, lastBackslash) + fs + "Fonts");
                return result;
            }
        }
        return result;
    }

    private static List<String> getDefaultLinuxFontDirectories() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("/usr/X11R6/lib/X11/fonts");
        result.add("/usr/share/fonts");
        return result;
    }
}

