/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.util;

import java.awt.Color;
import java.util.Map;
import ro.nextreports.engine.band.BandElement;

public class HtmlUtil {
    public static String getCssCode(BandElement be, Map<String, Object> style) {
        return HtmlUtil.getCssCode(be, style, true);
    }

    public static String getCssCode(BandElement be, Map<String, Object> style, boolean needed) {
        Object val;
        StringBuilder css = new StringBuilder();
        if (needed) {
            if (style.containsKey("font_family")) {
                val = (String)style.get("font_family");
                css.append(" font-family: ").append((String)val).append(" ;\n");
            }
            if (style.containsKey("font_size")) {
                val = (Float)style.get("font_size");
                css.append("font-size: ").append(((Float)val).intValue()).append("pt ;\n");
            }
        }
        if (style.containsKey("font_color")) {
            val = (Color)style.get("font_color");
            css.append("color: rgb(").append(((Color)val).getRed()).append(",").append(((Color)val).getGreen()).append(",").append(((Color)val).getBlue()).append(") ;\n");
        }
        if (style.containsKey("font_style_key")) {
            if ("font_stylet_normal".equals(style.get("font_style_key"))) {
                css.append("font-weight: normal ;\n");
                css.append("font-style: normal;  \n");
            }
            if ("font_style_bold".equals(style.get("font_style_key"))) {
                css.append("font-weight: bold; \n");
                css.append("font-style: normal;  \n");
            }
            if ("font_style_italic".equals(style.get("font_style_key"))) {
                css.append("font-weight: normal; \n");
                css.append("font-style: italic;  \n");
            }
            if ("font_style_bold_italic".equals(style.get("font_style_key"))) {
                css.append("font-weight: bold; \n");
                css.append("font-style: italic; \n");
            }
        }
        if (style.containsKey("bg_color") && (((Color)(val = (Color)style.get("bg_color"))).getRed() != 255 || ((Color)val).getGreen() != 255 || ((Color)val).getBlue() != 255)) {
            css.append("background-color: rgb(").append(((Color)val).getRed()).append(",").append(((Color)val).getGreen()).append(",").append(((Color)val).getBlue()).append(") ;\n");
        }
        if (style.containsKey("halign")) {
            if ("halign_left".equals(style.get("halign"))) {
                css.append("text-align:left; \n");
            }
            if ("halign_right".equals(style.get("halign"))) {
                css.append("text-align:right; \n");
            }
            if ("halign_center".equals(style.get("halign"))) {
                css.append("text-align:center; \n");
            }
        }
        if (style.containsKey("valign")) {
            if ("valign_middle".equals(style.get("valign"))) {
                css.append("vertical-align:middle; \n");
            }
            if ("valign_top".equals(style.get("valign"))) {
                css.append("vertical-align:top; \n");
            }
            if ("valign_bottom".equals(style.get("valign"))) {
                css.append("vertical-align:bottom; \n");
            }
        }
        if (style.containsKey("padding_left")) {
            val = (Float)style.get("padding_left");
            css.append("padding-left:").append(val).append("pt; \n");
        }
        if (style.containsKey("padding_right")) {
            val = (Float)style.get("padding_right");
            css.append("padding-right:").append(val).append("pt; \n");
        }
        if (style.containsKey("padding_top")) {
            val = (Float)style.get("padding_top");
            css.append("padding-top:").append(val).append("pt; \n");
        }
        if (style.containsKey("padding_bottom")) {
            val = (Float)style.get("padding_bottom");
            css.append("padding-bottom:").append(val).append("px; \n");
        }
        if (needed) {
            Color color;
            if (style.containsKey("border_left")) {
                val = (Float)style.get("border_left");
                css.append("border-left:").append(((Float)val).intValue()).append("px; \n");
                css.append("border-left-style:solid; \n");
                color = (Color)style.get("border_left_color");
                css.append("border-left-color: ").append(Integer.toHexString(color.getRGB() & 0xFFFFFF)).append(" ;\n");
            } else {
                css.append("border-left: none; \n");
            }
            if (style.containsKey("border_right")) {
                val = (Float)style.get("border_right");
                css.append("border-right:").append(((Float)val).intValue()).append("px; \n");
                css.append("border-right-style:solid; \n");
                color = (Color)style.get("border_right_color");
                css.append("border-right-color: ").append(Integer.toHexString(color.getRGB() & 0xFFFFFF)).append(" ;\n");
            } else {
                css.append("border-right: none; \n");
            }
            if (style.containsKey("border_top")) {
                val = (Float)style.get("border_top");
                css.append("border-top:").append(((Float)val).intValue()).append("px; \n");
                css.append("border-top-style:solid; \n");
                color = (Color)style.get("border_top_color");
                css.append("border-top-color: ").append(Integer.toHexString(color.getRGB() & 0xFFFFFF)).append(" ;\n");
            } else {
                css.append("border-top: none; \n");
            }
            if (style.containsKey("border_bottom")) {
                val = (Float)style.get("border_bottom");
                css.append("border-bottom:").append(((Float)val).intValue()).append("px; \n");
                css.append("border-bottom-style:solid; \n");
                color = (Color)style.get("border_bottom_color");
                css.append("border-bottom-color: ").append(Integer.toHexString(color.getRGB() & 0xFFFFFF)).append(" ;\n");
            } else {
                css.append("border-bottom: none; \n");
            }
        }
        if (be != null) {
            if (!be.isWrapText()) {
                css.append("white-space: nowrap; \n");
            } else {
                css.append("word-wrap: break-word; \n");
            }
        }
        return css.toString();
    }
}

