/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.util;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import ro.nextreports.engine.XStreamFactory;
import ro.nextreports.engine.chart.Chart;
import ro.nextreports.engine.util.ReportUtil;

public class NextChartUtil {
    public static byte CHART_VALID = 1;
    public static byte CHART_INVALID_NEWER = (byte)2;

    public static Chart loadChart(InputStream is) {
        XStream xstream = XStreamFactory.createXStream();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(is, "UTF-8");
            return (Chart)xstream.fromXML((Reader)reader);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public static String getVersion(String chartFile) {
        try {
            String text = ReportUtil.readAsString(chartFile);
            return NextChartUtil.getVersionFromText(text);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getVersion(byte[] reportContent) {
        String text = new String(reportContent);
        return NextChartUtil.getVersionFromText(text);
    }

    public static String getVersionFromText(String reportText) {
        String start = "<chart version=\"";
        int index = reportText.indexOf(start);
        if (index == -1) {
            return null;
        }
        int lastIndex = reportText.indexOf("\"", index += start.length());
        if (lastIndex == -1) {
            return null;
        }
        return reportText.substring(index, lastIndex);
    }

    public static byte isValidChartVersion(byte[] reportContent) {
        String reportVersion = NextChartUtil.getVersion(reportContent);
        return NextChartUtil.isValid(reportVersion);
    }

    public static byte isValidChartVersion(Chart chart) {
        String chartVersion = chart.getVersion();
        return NextChartUtil.isValid(chartVersion);
    }

    public static byte isValidChartVersion(String reportFile) {
        String reportVersion = NextChartUtil.getVersion(reportFile);
        return NextChartUtil.isValid(reportVersion);
    }

    public static byte isValid(String chartVersion) {
        if (ReportUtil.isNewerUnsupportedVersion(chartVersion)) {
            return CHART_INVALID_NEWER;
        }
        return CHART_VALID;
    }
}

