/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import ro.nextreports.engine.Report;
import ro.nextreports.engine.querybuilder.sql.dialect.ConnectionUtil;
import ro.nextreports.engine.querybuilder.sql.dialect.Dialect;
import ro.nextreports.engine.querybuilder.sql.dialect.DialectException;
import ro.nextreports.engine.queryexec.IdName;
import ro.nextreports.engine.queryexec.Query;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.queryexec.QueryExecutor;
import ro.nextreports.engine.queryexec.QueryParameter;
import ro.nextreports.engine.queryexec.QueryResult;
import ro.nextreports.engine.util.DialectUtil;
import ro.nextreports.engine.util.ParameterNotFoundException;
import ro.nextreports.engine.util.comparator.IdNameComparator;

public class ParameterUtil {
    public static final String NULL = "__NULL__";

    public void parametersAreDefined(Report report) throws ParameterNotFoundException {
        String sql = report.getSql();
        if (sql == null) {
            sql = report.getQuery().toString();
        }
        Query query = new Query(sql);
        String[] paramNames = query.getParameterNames();
        List<QueryParameter> parameters = report.getParameters();
        for (String paramName : paramNames) {
            QueryParameter param = null;
            for (QueryParameter p : parameters) {
                if (!paramName.equals(p.getName())) continue;
                param = p;
            }
            if (param != null) continue;
            throw new ParameterNotFoundException(paramName);
        }
    }

    public static List<IdName> getParameterValues(Connection con, QueryParameter parameter) throws SQLException, DialectException {
        List<IdName> values = new ArrayList<IdName>();
        if (parameter == null) {
            return values;
        }
        String source = parameter.getSource();
        if (parameter.isManualSource()) {
            if (!parameter.isDependent()) {
                values = ParameterUtil.getSelectValues(con, source, true, parameter.getOrderBy());
            }
        } else {
            String columnName;
            int index = source.indexOf(".");
            int index2 = source.lastIndexOf(".");
            String tableName = source.substring(0, index);
            String shownColumnName = null;
            if (index == index2) {
                columnName = source.substring(index + 1);
            } else {
                columnName = source.substring(index + 1, index2);
                shownColumnName = source.substring(index2 + 1);
            }
            values = ParameterUtil.getColumnValues(con, parameter.getSchema(), tableName, columnName, shownColumnName, parameter.getOrderBy());
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IdName> getColumnValues(Connection con, String schema, String table, String columnName, String shownColumnName, byte orderBy) throws SQLException, DialectException {
        ArrayList<IdName> values = new ArrayList<IdName>();
        Dialect dialect = DialectUtil.getDialect(con);
        ResultSet rs = null;
        String fromTable = table;
        if (schema != null && !"%".equals(schema)) {
            fromTable = schema + "." + table;
        }
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            if (columnName.contains(" ")) {
                columnName = dialect.getEscapedKeyWord(columnName);
            }
            String sql = shownColumnName == null ? "SELECT DISTINCT " + columnName + " FROM " + fromTable + " WHERE " + columnName + " IS NOT NULL ORDER BY " + columnName : "SELECT DISTINCT " + columnName + " , " + shownColumnName + " FROM " + fromTable + " WHERE " + columnName + " IS NOT NULL ORDER BY " + shownColumnName;
            rs = stmt.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            String type = rsmd.getColumnTypeName(1);
            int precision = rsmd.getPrecision(1);
            int scale = rsmd.getScale(1);
            int typeCode = dialect.getJdbcType(type, precision, scale);
            int typeCode2 = -1;
            if (shownColumnName != null) {
                String type2 = rsmd.getColumnTypeName(2);
                int precision2 = rsmd.getPrecision(2);
                int scale2 = rsmd.getScale(2);
                typeCode2 = dialect.getJdbcType(type2, precision2, scale2);
            }
            while (rs.next()) {
                IdName in = new IdName();
                switch (typeCode) {
                    case -7: {
                        in.setId(Boolean.valueOf(rs.getBoolean(1)));
                        break;
                    }
                    case 5: {
                        in.setId(Short.valueOf(rs.getShort(1)));
                        break;
                    }
                    case 2: 
                    case 4: {
                        in.setId(Integer.valueOf(rs.getInt(1)));
                        break;
                    }
                    case 6: {
                        in.setId(Float.valueOf(rs.getFloat(1)));
                        break;
                    }
                    case -5: {
                        in.setId(rs.getBigDecimal(1));
                        break;
                    }
                    case 8: {
                        in.setId(Double.valueOf(rs.getDouble(1)));
                        break;
                    }
                    case 91: {
                        in.setId(rs.getDate(1));
                        break;
                    }
                    case 92: {
                        in.setId(rs.getTime(1));
                        break;
                    }
                    case 93: {
                        in.setId(rs.getTimestamp(1));
                        break;
                    }
                    case 1: 
                    case 12: {
                        in.setId((Serializable)((Object)rs.getString(1)));
                        break;
                    }
                    default: {
                        throw new SQLException("NEXTREPORTS -> getColumnValues: type for value cannot be Serialized.");
                    }
                }
                ParameterUtil.setName(shownColumnName, in, rs, typeCode2);
                values.add(in);
                Collections.sort(values, new IdNameComparator(orderBy));
            }
        }
        catch (Throwable throwable) {
            ConnectionUtil.closeResultSet(rs);
            ConnectionUtil.closeStatement(stmt);
            throw throwable;
        }
        ConnectionUtil.closeResultSet(rs);
        ConnectionUtil.closeStatement(stmt);
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IdName> getSelectValues(Connection con, String select, boolean sort, byte orderBy) throws SQLException, DialectException {
        ArrayList<IdName> values = new ArrayList<IdName>();
        ResultSet rs = null;
        Statement stmt = null;
        Dialect dialect = DialectUtil.getDialect(con);
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(select);
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            if (columnCount > 2) {
                throw new SQLException("Invalid sql.");
            }
            String type = rsmd.getColumnTypeName(1);
            int precision = rsmd.getPrecision(1);
            int scale = rsmd.getScale(1);
            int typeCode = dialect.getJdbcType(type, precision, scale);
            while (rs.next()) {
                Object s;
                boolean date = false;
                switch (typeCode) {
                    case 2: 
                    case 4: {
                        s = rs.getInt(1);
                        break;
                    }
                    case -5: {
                        s = rs.getBigDecimal(1);
                        break;
                    }
                    case 8: {
                        s = rs.getDouble(1);
                        break;
                    }
                    case 91: {
                        date = true;
                        s = rs.getDate(1);
                        break;
                    }
                    case 92: {
                        date = true;
                        s = rs.getTime(1);
                        break;
                    }
                    case 93: {
                        date = true;
                        s = rs.getTimestamp(1);
                        break;
                    }
                    case 12: {
                        s = rs.getString(1);
                        break;
                    }
                    default: {
                        s = rs.getString(1);
                    }
                }
                IdName in = new IdName();
                in.setId((Serializable)s);
                if (columnCount == 1) {
                    if (date) {
                        in.setName((Serializable)s);
                    } else {
                        in.setName((Serializable)((Object)rs.getString(1)));
                    }
                } else {
                    in.setName((Serializable)((Object)rs.getString(2)));
                }
                if (values.contains(in)) continue;
                values.add(in);
            }
            if (sort && (orderBy == 2 || orderBy == 1)) {
                Collections.sort(values, new IdNameComparator(orderBy));
            }
        }
        catch (Throwable throwable) {
            ConnectionUtil.closeResultSet(rs);
            ConnectionUtil.closeStatement(stmt);
            throw throwable;
        }
        ConnectionUtil.closeResultSet(rs);
        ConnectionUtil.closeStatement(stmt);
        return values;
    }

    public static List<IdName> getRuntimeParameterValues(Connection con, QueryParameter qp, Map<String, QueryParameter> map, Map<String, Object> vals) throws Exception {
        List<IdName> values = new ArrayList<IdName>();
        if (qp.isManualSource()) {
            try (QueryResult qr = null;){
                Query query = new Query(qp.getSource());
                QueryExecutor executor = new QueryExecutor(query, map, vals, con, false, false, false);
                executor.setTimeout(10000);
                executor.setMaxRows(0);
                qr = executor.execute();
                while (qr.hasNext()) {
                    IdName in = new IdName();
                    in.setId((Serializable)qr.nextValue(0));
                    if (qr.getColumnCount() == 1) {
                        in.setName((Serializable)qr.nextValue(0));
                    } else {
                        in.setName((Serializable)qr.nextValue(1));
                    }
                    values.add(in);
                }
            }
        } else {
            String columnName;
            String source = qp.getSource();
            int index = source.indexOf(".");
            int index2 = source.lastIndexOf(".");
            String tableName = source.substring(0, index);
            String shownColumnName = null;
            if (index == index2) {
                columnName = source.substring(index + 1);
            } else {
                columnName = source.substring(index + 1, index2);
                shownColumnName = source.substring(index2 + 1);
            }
            values = ParameterUtil.getColumnValues(con, qp.getSchema(), tableName, columnName, shownColumnName, qp.getOrderBy());
        }
        return values;
    }

    public static List<IdName> getParameterValues(Connection con, QueryParameter qp, Map<String, QueryParameter> map, Map<String, Serializable> vals) throws Exception {
        HashMap<String, Object> objVals = new HashMap<String, Object>();
        for (String key : vals.keySet()) {
            Object[] s = vals.get(key);
            if (s instanceof Serializable[]) {
                Serializable[] array = (Serializable[])s;
                Object[] objArray = new Object[array.length];
                for (Object objArray[i] : array) {
                }
                s = objArray;
            }
            objVals.put(key, s);
        }
        try (QueryResult qr = null;){
            ArrayList<IdName> values = new ArrayList<IdName>();
            Query query = new Query(qp.getSource());
            QueryExecutor executor = new QueryExecutor(query, map, objVals, con, false, false, false);
            executor.setTimeout(10000);
            executor.setMaxRows(0);
            qr = executor.execute();
            while (qr.hasNext()) {
                IdName in = new IdName();
                in.setId((Serializable)qr.nextValue(0));
                if (qr.getColumnCount() == 1) {
                    in.setName((Serializable)qr.nextValue(0));
                } else {
                    in.setName((Serializable)qr.nextValue(1));
                }
                values.add(in);
            }
            ArrayList<IdName> arrayList = values;
            return arrayList;
        }
    }

    public static ArrayList<Serializable> getDefaultSourceValues(Connection con, QueryParameter qp) throws Exception {
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        List<IdName> list = ParameterUtil.getSelectValues(con, qp.getDefaultSource(), false, (byte)-1);
        if ("Single".equals(qp.getSelection())) {
            for (IdName in : list) {
                result.add(in.getId());
            }
        } else {
            for (IdName in : list) {
                result.add(in);
            }
        }
        return result;
    }

    private static void setName(String shownColumnName, IdName in, ResultSet rs, int typeCode) throws SQLException {
        if (shownColumnName == null) {
            return;
        }
        switch (typeCode) {
            case 4: {
                in.setName(Integer.valueOf(rs.getInt(2)));
                break;
            }
            case -5: {
                in.setName(rs.getBigDecimal(2));
                break;
            }
            case 8: {
                in.setName(Double.valueOf(rs.getDouble(2)));
                break;
            }
            case 91: {
                in.setName(rs.getDate(2));
                break;
            }
            case 92: {
                in.setName(rs.getTime(2));
                break;
            }
            case 93: {
                in.setName(rs.getTimestamp(2));
                break;
            }
            case 12: {
                in.setName((Serializable)((Object)rs.getString(2)));
                break;
            }
            default: {
                throw new SQLException("NEXTREPORTS -> getColumnValues/setName: type for value cannot be Serialized.");
            }
        }
    }

    public static Map<String, QueryParameter> getChildDependentParameters(Report report, String parameterName) {
        if (report == null) {
            return new HashMap<String, QueryParameter>();
        }
        for (QueryParameter qp : report.getParameters()) {
            if (!qp.getName().equals(parameterName)) continue;
            return ParameterUtil.getChildDependentParameters(report.getParameters(), qp);
        }
        return new HashMap<String, QueryParameter>();
    }

    public static Map<String, QueryParameter> getChildDependentParameters(Report report, QueryParameter p) {
        if (report == null) {
            return new HashMap<String, QueryParameter>();
        }
        return ParameterUtil.getChildDependentParameters(report.getParameters(), p);
    }

    public static Map<String, QueryParameter> getChildDependentParameters(List<QueryParameter> params, QueryParameter p) {
        HashMap<String, QueryParameter> result = new HashMap<String, QueryParameter>();
        for (QueryParameter param : params) {
            List<String> names;
            if (param.equals(p) || !param.isDependent() || !(names = param.getDependentParameterNames()).contains(p.getName())) continue;
            result.put(param.getName(), param);
        }
        return result;
    }

    public static Map<String, QueryParameter> getParentDependentParameters(Report report, QueryParameter p) {
        return ParameterUtil.getParentDependentParameters(report.getParameters(), p);
    }

    public static Map<String, QueryParameter> getParentDependentParameters(List<QueryParameter> params, QueryParameter p) {
        List<String> names = p.getDependentParameterNames();
        HashMap<String, QueryParameter> result = new HashMap<String, QueryParameter>();
        for (String name : names) {
            result.put(name, ParameterUtil.getParameterByName(params, name));
        }
        return result;
    }

    public static QueryParameter getParameterByName(Report report, String parameterName) {
        return ParameterUtil.getParameterByName(report.getParameters(), parameterName);
    }

    public static QueryParameter getParameterByName(List<QueryParameter> params, String parameterName) {
        for (QueryParameter parameter : params) {
            if (!parameter.getName().equals(parameterName)) continue;
            return parameter;
        }
        return null;
    }

    public static Map<String, QueryParameter> getUsedParametersMap(Report report) {
        return ParameterUtil.getUsedParametersMap(report, true, false);
    }

    public static Map<String, QueryParameter> getUsedNotHiddenParametersMap(Report report) {
        return ParameterUtil.getUsedParametersMap(report, false, false);
    }

    public static Map<String, QueryParameter> getUsedHiddenParametersMap(Report report) {
        return ParameterUtil.getUsedParametersMap(report, false, true);
    }

    private static Map<String, QueryParameter> getUsedParametersMap(Report report, boolean withHidden, boolean onlyHidden) {
        if (report == null) {
            return new HashMap<String, QueryParameter>();
        }
        String sql = report.getSql();
        if (sql == null) {
            sql = report.getQuery().toString();
        }
        Query query = new Query(sql);
        String[] paramNames = query.getParameterNames();
        LinkedHashMap<String, QueryParameter> params = new LinkedHashMap<String, QueryParameter>();
        for (QueryParameter qp : report.getParameters()) {
            String name = qp.getName();
            boolean found = false;
            for (String pName : paramNames) {
                if (!pName.equals(name)) continue;
                if (onlyHidden) {
                    if (!qp.isHidden()) continue;
                    found = true;
                    break;
                }
                if (qp.isHidden() && (!qp.isHidden() || !withHidden)) continue;
                found = true;
                break;
            }
            if (!found && ParameterUtil.getChildDependentParameters(report, qp).size() > 0) {
                found = true;
            }
            if (onlyHidden) {
                if (!found) continue;
                params.put(name, qp);
                continue;
            }
            if (!found && (!qp.isHidden() || !withHidden)) continue;
            params.put(name, qp);
        }
        return params;
    }

    public static Map<String, QueryParameter> getUsedParametersMap(Query query, Map<String, QueryParameter> allParameters) {
        HashSet<String> paramNames = new HashSet<String>(Arrays.asList(query.getParameterNames()));
        for (QueryParameter p : allParameters.values()) {
            paramNames.addAll(p.getDependentParameterNames());
        }
        LinkedHashMap<String, QueryParameter> params = new LinkedHashMap<String, QueryParameter>();
        for (String name : allParameters.keySet()) {
            boolean found = false;
            for (String pName : paramNames) {
                if (!pName.equals(name)) continue;
                found = true;
                break;
            }
            QueryParameter qp = allParameters.get(name);
            if (!found && !qp.isHidden()) continue;
            params.put(name, qp);
        }
        return params;
    }

    public static Map<String, QueryParameter> getOrderedParametersMap(Query query, Map<String, QueryParameter> allParameters) {
        LinkedHashSet<String> paramNames = new LinkedHashSet<String>(Arrays.asList(query.getParameterNames()));
        for (QueryParameter p : allParameters.values()) {
            if (p.getDependentParameterNames().size() > 0) {
                paramNames.remove(p.getName());
            }
            paramNames.addAll(p.getDependentParameterNames());
            if (p.getDependentParameterNames().size() <= 0) continue;
            paramNames.add(p.getName());
        }
        LinkedHashMap<String, QueryParameter> params = new LinkedHashMap<String, QueryParameter>();
        for (String name : paramNames) {
            QueryParameter qp = allParameters.get(name);
            params.put(name, qp);
        }
        return params;
    }

    public static Map<String, QueryParameter> getUsedParametersMap(String sql, Map<String, QueryParameter> allParameters) {
        Query query = new Query(sql);
        return ParameterUtil.getUsedParametersMap(query, allParameters);
    }

    public static boolean allParametersAreHidden(Map<String, QueryParameter> map) {
        for (QueryParameter qp : map.values()) {
            if (qp.isHidden()) continue;
            return false;
        }
        return true;
    }

    public static boolean allParametersHaveDefaults(Map<String, QueryParameter> map) {
        for (QueryParameter qp : map.values()) {
            if (qp.getDefaultValues() != null && qp.getDefaultValues().size() != 0 || qp.getDefaultSource() != null && !"".equals(qp.getDefaultSource().trim())) continue;
            return false;
        }
        return true;
    }

    public static void initAllRuntimeParameterValues(QueryParameter param, List<IdName> values, Map<String, Object> parameterValues) throws QueryException {
        if (param.getSelection().equals("Single")) {
            parameterValues.put(param.getName(), values.get(0));
        } else {
            Object[] val = new Object[values.size()];
            int size = values.size();
            for (int k = 0; k < size; ++k) {
                val[k] = values.get(k);
            }
            parameterValues.put(param.getName(), val);
        }
    }

    public static void initDefaultParameterValues(QueryParameter param, List<Serializable> defValues, Map<String, Object> parameterValues) throws QueryException {
        if (param.getSelection().equals("Single")) {
            parameterValues.put(param.getName(), defValues.get(0));
        } else {
            Object[] val = new Object[defValues.size()];
            int size = defValues.size();
            for (int k = 0; k < size; ++k) {
                val[k] = defValues.get(k);
            }
            parameterValues.put(param.getName(), val);
        }
    }

    public static void initDefaultSParameterValues(QueryParameter param, List<Serializable> defValues, Map<String, Serializable> parameterValues) throws QueryException {
        if (param.getSelection().equals("Single")) {
            parameterValues.put(param.getName(), defValues.get(0));
        } else {
            Object[] val = new Object[defValues.size()];
            int size = defValues.size();
            for (int k = 0; k < size; ++k) {
                val[k] = defValues.get(k);
            }
            parameterValues.put(param.getName(), (Serializable)val);
        }
    }

    public static void initStaticDefaultParameterValues(QueryParameter param, Map<String, Object> parameterValues) throws QueryException {
        if (param.getDefaultValues() == null || param.getDefaultValues().size() <= 0) {
            throw new QueryException("Invalid use of method initStaticDefaultParameterValues : no static values for parameter " + param.getName());
        }
        ArrayList<Serializable> defValues = param.getDefaultValues();
        ParameterUtil.initDefaultParameterValues(param, defValues, parameterValues);
    }

    public static void initDefaultParameterValues(Connection conn, QueryParameter param, Map<String, Object> parameterValues) throws QueryException {
        ArrayList<Serializable> defValues;
        if (param.getDefaultValues() != null && param.getDefaultValues().size() > 0) {
            defValues = param.getDefaultValues();
        } else {
            try {
                defValues = ParameterUtil.getDefaultSourceValues(conn, param);
            }
            catch (Exception e) {
                throw new QueryException(e);
            }
        }
        ParameterUtil.initDefaultParameterValues(param, defValues, parameterValues);
    }

    public static void initAllRuntimeParameterValues(Connection conn, QueryParameter param, Map<String, QueryParameter> map, Map<String, Object> parameterValues) throws QueryException {
        List<IdName> allValues = new ArrayList<IdName>();
        if (param.getSource() != null && !param.getSource().trim().equals("")) {
            try {
                allValues = ParameterUtil.getRuntimeParameterValues(conn, param, map, parameterValues);
            }
            catch (Exception e) {
                throw new QueryException(e);
            }
        }
        ParameterUtil.initAllRuntimeParameterValues(param, allValues, parameterValues);
    }

    public static void initDefaultSParameterValues(Connection conn, QueryParameter param, Map<String, Serializable> parameterValues) throws QueryException {
        ArrayList<Serializable> defValues;
        if (param.getDefaultValues() != null && param.getDefaultValues().size() > 0) {
            defValues = param.getDefaultValues();
        } else {
            try {
                defValues = ParameterUtil.getDefaultSourceValues(conn, param);
            }
            catch (Exception e) {
                throw new QueryException(e);
            }
        }
        ParameterUtil.initDefaultSParameterValues(param, defValues, parameterValues);
    }

    public static void initStaticNotHiddenDefaultParameterValues(Report report, Map<String, Object> parameterValues) throws QueryException {
        Map<String, QueryParameter> params = ParameterUtil.getUsedParametersMap(report);
        for (QueryParameter qp : params.values()) {
            if (qp.isHidden()) continue;
            ParameterUtil.initStaticDefaultParameterValues(qp, parameterValues);
        }
    }

    public static void initNotHiddenDefaultParameterValues(Connection conn, Report report, Map<String, Object> parameterValues) throws QueryException {
        Map<String, QueryParameter> params = ParameterUtil.getUsedParametersMap(report);
        for (QueryParameter qp : params.values()) {
            if (qp.isHidden()) continue;
            ParameterUtil.initDefaultParameterValues(conn, qp, parameterValues);
        }
    }

    public static boolean checkForParametersWithDefaultSource(Report report) {
        Map<String, QueryParameter> params = ParameterUtil.getUsedParametersMap(report);
        for (QueryParameter qp : params.values()) {
            if (qp.getDefaultSource() == null || qp.getDefaultSource().equals("")) continue;
            return true;
        }
        return false;
    }

    public static Map<String, QueryParameter> toMap(List<QueryParameter> parameters) {
        HashMap<String, QueryParameter> map = new HashMap<String, QueryParameter>();
        for (QueryParameter qp : parameters) {
            map.put(qp.getName(), qp);
        }
        return map;
    }

    public static Object getParameterValueFromString(String parameterClass, String value) throws Exception {
        return ParameterUtil.getParameterValueFromString(parameterClass, value, null);
    }

    public static Object getParameterValueFromStringWithPattern(String parameterClass, String value, String pattern) throws Exception {
        if (pattern == null) {
            return ParameterUtil.getParameterValueFromString(parameterClass, value);
        }
        if ("java.util.Date".equals(parameterClass) || "java.sql.Time".equals(parameterClass) || "java.sql.Timestamp".equals(parameterClass)) {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            return ParameterUtil.getParameterValueFromString(parameterClass, value, sdf);
        }
        return ParameterUtil.getParameterValueFromString(parameterClass, value);
    }

    public static Object getParameterValueFromString(String parameterClass, String value, SimpleDateFormat sdf) throws Exception {
        Object result = value;
        if (result == null) {
            return result;
        }
        try {
            if ("java.lang.Integer".equals(parameterClass)) {
                result = Integer.parseInt(value);
            } else if ("java.lang.Byte".equals(parameterClass)) {
                result = Byte.parseByte(value);
            } else if ("java.lang.Short".equals(parameterClass)) {
                result = Short.parseShort(value);
            } else if ("java.lang.Long".equals(parameterClass)) {
                result = Long.parseLong(value);
            } else if ("java.lang.Float".equals(parameterClass)) {
                result = Float.valueOf(Float.parseFloat(value));
            } else if ("java.lang.Double".equals(parameterClass)) {
                result = Double.parseDouble(value);
            } else if ("java.lang.Boolean".equals(parameterClass)) {
                result = Boolean.parseBoolean(value);
            } else if ("java.math.BigDecimal".equals(parameterClass)) {
                result = new BigDecimal(value);
            } else if ("java.math.BigInteger".equals(parameterClass)) {
                result = new BigInteger(value);
            } else if ("java.util.Date".equals(parameterClass)) {
                if (sdf == null) {
                    sdf = new SimpleDateFormat();
                    try {
                        result = sdf.parse(value);
                    }
                    catch (ParseException ex) {
                        result = DateFormat.getDateInstance().parse(value);
                    }
                } else {
                    result = sdf.parse(value);
                }
            } else if ("java.sql.Time".equals(parameterClass)) {
                result = sdf != null ? sdf.parse(value) : Time.valueOf(value);
            } else if ("java.sql.Timestamp".equals(parameterClass)) {
                result = sdf != null ? sdf.parse(value) : Timestamp.valueOf(value);
            }
            return result;
        }
        catch (NumberFormatException ex) {
            throw new Exception("Cannot parse " + parameterClass + " value from text " + value);
        }
        catch (ParseException ex) {
            throw new Exception("Cannot parse " + parameterClass + " value from text " + value);
        }
    }

    public static Map<String, QueryParameter> intersectParametersMap(List<Report> reports) {
        Map<String, QueryParameter> paramMap;
        Map<String, QueryParameter> map = new LinkedHashMap<String, QueryParameter>();
        if (reports == null || reports.size() == 0) {
            return map;
        }
        if (reports.size() == 1) {
            return ParameterUtil.getUsedParametersMap(reports.get(0), false, false);
        }
        Map<String, QueryParameter> firstParamMap = ParameterUtil.getUsedParametersMap(reports.get(0), false, false);
        Map<String, QueryParameter> secondParamMap = ParameterUtil.getUsedParametersMap(reports.get(1), false, false);
        map = ParameterUtil.intersectParametersMap(firstParamMap, secondParamMap);
        int n = reports.size();
        for (int i = 2; i < n && (map = ParameterUtil.intersectParametersMap(map, paramMap = ParameterUtil.getUsedParametersMap(reports.get(i), false, false))).size() != 0; ++i) {
        }
        return map;
    }

    private static Map<String, QueryParameter> intersectParametersMap(Map<String, QueryParameter> firstParamMap, Map<String, QueryParameter> secondParamMap) {
        LinkedHashMap<String, QueryParameter> map = new LinkedHashMap<String, QueryParameter>();
        if (firstParamMap == null || firstParamMap.size() == 0 || secondParamMap == null || secondParamMap.size() == 0) {
            return map;
        }
        for (QueryParameter qp : secondParamMap.values()) {
            for (QueryParameter qp2 : firstParamMap.values()) {
                if (!qp.compare(qp2) || map.containsKey(qp.getName())) continue;
                map.put(qp.getName(), qp);
            }
        }
        return map;
    }

    public static String getDebugParameters(Map<String, ? extends Object> parametersValues) {
        SimpleDateFormat timeFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        SimpleDateFormat dayFormat = new SimpleDateFormat("dd/MM/yyyy");
        if (parametersValues == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String key : parametersValues.keySet()) {
            Object value = parametersValues.get(key);
            sb.append(" ").append(key).append(" = ");
            if (value == null) {
                sb.append("null\r\n");
                continue;
            }
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                sb.append("[");
                int size = values.length;
                for (int i = 0; i < size; ++i) {
                    Object obj = values[i];
                    if (obj instanceof IdName) {
                        sb.append(((IdName)obj).getId());
                    } else if (obj instanceof Date) {
                        sb.append(dayFormat.format((Date)obj));
                    } else if (obj instanceof Timestamp) {
                        Date date = new Date(((Timestamp)obj).getTime());
                        sb.append(timeFormat.format(date));
                    } else {
                        sb.append(obj);
                    }
                    if (i >= size - 1) continue;
                    sb.append(";");
                }
                sb.append("]");
            } else if (value instanceof IdName) {
                sb.append(((IdName)value).getId());
            } else if (value instanceof Date) {
                sb.append(dayFormat.format((Date)value));
            } else if (value instanceof Timestamp) {
                Date date = new Date(((Timestamp)value).getTime());
                sb.append(timeFormat.format(date));
            } else {
                sb.append(value);
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static boolean isDateTime(QueryParameter qp) {
        String className = qp.getValueClassName();
        return className.equals("java.util.Date") || className.equals("java.sql.Time") || className.equals("java.sql.Timestamp");
    }
}

