/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.util;

import java.io.Serializable;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ro.nextreports.engine.querybuilder.sql.dialect.ConnectionUtil;
import ro.nextreports.engine.querybuilder.sql.dialect.Dialect;
import ro.nextreports.engine.querybuilder.sql.dialect.OracleDialect;
import ro.nextreports.engine.queryexec.IdName;
import ro.nextreports.engine.queryexec.Query;
import ro.nextreports.engine.queryexec.QueryChunk;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.queryexec.QueryExecutor;
import ro.nextreports.engine.queryexec.QueryParameter;
import ro.nextreports.engine.queryexec.QueryResult;
import ro.nextreports.engine.queryexec.util.SqlFile;
import ro.nextreports.engine.util.DialectUtil;
import ro.nextreports.engine.util.NameType;
import ro.nextreports.engine.util.ReportUtil;

public class QueryUtil {
    private static Log LOG = LogFactory.getLog(QueryUtil.class);
    private Connection con;
    private Dialect dialect;

    public QueryUtil(Connection con, Dialect dialect) {
        this.con = con;
        this.dialect = dialect;
    }

    public String getSqlFromFile(String file) throws Exception {
        System.out.println("=== sql ===");
        SqlFile sqlFile = new SqlFile(file);
        String sql = sqlFile.getSqlList().get(0);
        System.out.println(sql);
        return sql;
    }

    public List<String> getColumnNames(String sql, Map<String, QueryParameter> params) throws Exception {
        return this.getColumnNames(sql, params, null);
    }

    public List<String> getColumnNames(String sql, Map<String, QueryParameter> params, List<NameType> cachedColumns) throws Exception {
        List<NameType> list = this.getColumns(sql, params, cachedColumns);
        ArrayList<String> columns = new ArrayList<String>();
        for (NameType nt : list) {
            columns.add(nt.getName());
        }
        return columns;
    }

    public List<String> getColumnTypes(String sql, Map<String, QueryParameter> params, List<NameType> cachedColumns) throws Exception {
        List<NameType> list = this.getColumns(sql, params, cachedColumns);
        return ReportUtil.getColumnNames(list);
    }

    public String getColumnType(String sql, Map<String, QueryParameter> params, String columnName, List<NameType> cachedColumns) throws Exception {
        List<NameType> list = this.getColumns(sql, params, cachedColumns);
        for (NameType nt : list) {
            if (!nt.getName().equalsIgnoreCase(columnName)) continue;
            return nt.getType();
        }
        return null;
    }

    public List<NameType> getColumns(String sql, Map<String, QueryParameter> params) throws Exception {
        return this.getColumns(sql, params, null);
    }

    public List<NameType> getColumns(String sql, Map<String, QueryParameter> params, List<NameType> cachedColumns) throws Exception {
        QueryChunk[] chunks;
        if (cachedColumns != null) {
            return cachedColumns;
        }
        Query query = new Query(sql);
        String[] paramNames = query.getParameterNames();
        if (paramNames.length == 0) {
            return this.executeQueryForColumnNames(sql);
        }
        StringWriter sqlWithoutParameters = new StringWriter(100);
        for (QueryChunk chunk : chunks = query.getChunks()) {
            byte chunckType = chunk.getType();
            if (1 == chunckType) {
                sqlWithoutParameters.append(chunk.getText());
                continue;
            }
            if (2 != chunckType) continue;
            String paramName = chunk.getText();
            QueryParameter param = params.get(paramName);
            if (param == null) {
                throw new Exception("Parameter '" + paramName + "' not defined.");
            }
            boolean afterIn = sqlWithoutParameters.getBuffer().toString().trim().toLowerCase().endsWith("IN".toLowerCase());
            if (afterIn) {
                sqlWithoutParameters.append("(");
            }
            sqlWithoutParameters.append(this.getDummyValueForParameter(param));
            if (!afterIn) continue;
            sqlWithoutParameters.append(")");
        }
        return this.executeQueryForColumnNames(sqlWithoutParameters.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NameType> executeQueryForColumnNames(String sql) throws Exception {
        ArrayList<NameType> arrayList;
        StringWriter sw = new StringWriter(100);
        sw.append(sql);
        String sqlForHeader = sw.toString();
        LOG.info((Object)("call for header columns = " + sqlForHeader));
        ResultSet rs = null;
        Statement stmt = null;
        try {
            if (QueryUtil.isProcedureCall(sqlForHeader)) {
                Dialect dialect = DialectUtil.getDialect(this.con);
                CallableStatement cs = this.con.prepareCall("{" + sqlForHeader + "}");
                stmt = cs;
                if (dialect.hasProcedureWithCursor()) {
                    cs.registerOutParameter(1, dialect.getCursorSqlType());
                }
                rs = cs.executeQuery();
                if (dialect.hasProcedureWithCursor()) {
                    rs = (ResultSet)cs.getObject(1);
                }
            } else {
                stmt = this.con.createStatement();
                stmt.setMaxRows(1);
                rs = stmt.executeQuery(sqlForHeader);
            }
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            ArrayList<NameType> columnNames = new ArrayList<NameType>();
            for (int i = 0; i < columnCount; ++i) {
                columnNames.add(new NameType(rsmd.getColumnLabel(i + 1), this.dialect.getJavaType(rsmd.getColumnTypeName(i + 1), rsmd.getPrecision(i + 1), rsmd.getScale(i + 1))));
            }
            arrayList = columnNames;
        }
        catch (Throwable throwable) {
            ConnectionUtil.closeResultSet(rs);
            ConnectionUtil.closeStatement(stmt);
            throw throwable;
        }
        ConnectionUtil.closeResultSet(rs);
        ConnectionUtil.closeStatement(stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NameType> executeQueryForDynamicColumn(String sql) throws Exception {
        ArrayList<NameType> arrayList;
        StringWriter sw = new StringWriter(100);
        sw.append(sql);
        String sqlForHeader = sw.toString();
        LOG.info((Object)("call for chart dynamic columns = " + sqlForHeader));
        ResultSet rs = null;
        Statement stmt = null;
        try {
            if (QueryUtil.isProcedureCall(sqlForHeader)) {
                Dialect dialect = DialectUtil.getDialect(this.con);
                CallableStatement cs = this.con.prepareCall("{" + sqlForHeader + "}");
                stmt = cs;
                if (dialect.hasProcedureWithCursor()) {
                    cs.registerOutParameter(1, dialect.getCursorSqlType());
                }
                rs = cs.executeQuery();
                if (dialect.hasProcedureWithCursor()) {
                    rs = (ResultSet)cs.getObject(1);
                }
            } else {
                stmt = this.con.createStatement();
                rs = stmt.executeQuery(sqlForHeader);
            }
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            if (columnCount != 2) {
                throw new QueryException("Column query must have two data columns : column name and column legend.");
            }
            ArrayList<NameType> columnNames = new ArrayList<NameType>();
            while (rs.next()) {
                columnNames.add(new NameType(rs.getString(1), rs.getString(2)));
            }
            arrayList = columnNames;
        }
        catch (Throwable throwable) {
            ConnectionUtil.closeResultSet(rs);
            ConnectionUtil.closeStatement(stmt);
            throw throwable;
        }
        ConnectionUtil.closeResultSet(rs);
        ConnectionUtil.closeStatement(stmt);
        return arrayList;
    }

    private String getDummyValueForParameter(QueryParameter param) throws Exception {
        if (param.isProcedureParameter()) {
            String valueClassName = param.getValueClassName();
            if ("java.lang.String".equals(valueClassName)) {
                return "'" + param.getPreviewValue() + "'";
            }
            return param.getPreviewValue();
        }
        String valueClassName = param.getValueClassName();
        if ("java.lang.String".equals(valueClassName)) {
            return "'dummy'";
        }
        if ("java.lang.Boolean".equals(valueClassName)) {
            return "1";
        }
        if ("java.lang.Byte".equals(valueClassName)) {
            return "0";
        }
        if ("java.lang.Double".equals(valueClassName)) {
            return "0";
        }
        if ("java.lang.Long".equals(valueClassName)) {
            return "0";
        }
        if ("java.lang.Float".equals(valueClassName)) {
            return "0";
        }
        if ("java.lang.Integer".equals(valueClassName)) {
            return "0";
        }
        if ("java.lang.Short".equals(valueClassName)) {
            return "0";
        }
        if ("java.util.Date".equals(valueClassName)) {
            return this.dialect.getCurrentDate();
        }
        if ("java.sql.Time".equals(valueClassName)) {
            return this.dialect.getCurrentTime();
        }
        if ("java.sql.Timestamp".equals(valueClassName)) {
            return this.dialect.getCurrentTimestamp();
        }
        if ("java.lang.Object".equals(valueClassName)) {
            return "0";
        }
        if ("java.math.BigDecimal".equals(valueClassName)) {
            return "0";
        }
        if ("java.math.BigInteger".equals(valueClassName)) {
            return "0";
        }
        return "dummy";
    }

    public QueryResult executeQueryFromFile(String file) throws Exception {
        String sql = this.getSqlFromFile(file);
        Query query = new Query(sql);
        HashMap<String, QueryParameter> parameters = new HashMap<String, QueryParameter>();
        HashMap<String, Object> values = new HashMap<String, Object>();
        QueryExecutor executor = new QueryExecutor(query, parameters, values, this.con);
        QueryResult result = executor.execute();
        return result;
    }

    public static boolean restrictQueryExecution(String sql) {
        String[] restrictions = new String[]{"delete", "truncate", "update", "drop", "alter"};
        if (sql != null) {
            sql = sql.toLowerCase();
            for (String restriction : restrictions) {
                if (sql.startsWith(restriction)) {
                    return true;
                }
                String regex = "\\s+" + restriction + "\\s+";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(sql);
                if (!matcher.find()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isProcedureCall(String sql) {
        if (sql == null) {
            return false;
        }
        return sql.toLowerCase().startsWith("call ");
    }

    public static boolean isValidProcedureCall(String sql, Dialect dialect) {
        if (sql == null) {
            return false;
        }
        if (dialect instanceof OracleDialect) {
            return sql.split("\\?").length == 2;
        }
        return true;
    }

    public List<IdName> getValues(String sql, Map<String, QueryParameter> map, Map<String, Object> vals) throws Exception {
        ArrayList<IdName> values = new ArrayList<IdName>();
        try (QueryResult qr = null;){
            Query query = new Query(sql);
            QueryExecutor executor = new QueryExecutor(query, map, vals, this.con, false, false, false);
            executor.setTimeout(10000);
            executor.setMaxRows(0);
            qr = executor.execute();
            while (qr.hasNext()) {
                IdName in = new IdName();
                in.setId((Serializable)qr.nextValue(0));
                if (qr.getColumnCount() == 1) {
                    in.setName((Serializable)qr.nextValue(0));
                } else {
                    in.setName((Serializable)qr.nextValue(1));
                }
                values.add(in);
            }
        }
        return values;
    }
}

