/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.util;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ro.nextreports.engine.ReleaseInfoAdapter;
import ro.nextreports.engine.Report;
import ro.nextreports.engine.ReportGroup;
import ro.nextreports.engine.ReportLayout;
import ro.nextreports.engine.XStreamFactory;
import ro.nextreports.engine.band.Band;
import ro.nextreports.engine.band.BandElement;
import ro.nextreports.engine.band.BarcodeBandElement;
import ro.nextreports.engine.band.ChartBandElement;
import ro.nextreports.engine.band.ExpressionBandElement;
import ro.nextreports.engine.band.ExpressionBean;
import ro.nextreports.engine.band.FieldBandElement;
import ro.nextreports.engine.band.ForReportBandElement;
import ro.nextreports.engine.band.FunctionBandElement;
import ro.nextreports.engine.band.ImageBandElement;
import ro.nextreports.engine.band.ReportBandElement;
import ro.nextreports.engine.chart.Chart;
import ro.nextreports.engine.exporter.util.ParametersBean;
import ro.nextreports.engine.queryexec.IdName;
import ro.nextreports.engine.queryexec.QueryParameter;
import ro.nextreports.engine.util.DialectUtil;
import ro.nextreports.engine.util.LoadReportException;
import ro.nextreports.engine.util.NameType;
import ro.nextreports.engine.util.ObjectCloner;
import ro.nextreports.engine.util.QueryUtil;
import ro.nextreports.engine.util.StringUtil;
import ro.nextreports.engine.util.converter.ConverterChain;
import ro.nextreports.engine.util.converter.ConverterException;

public class ReportUtil {
    public static byte REPORT_VALID = 1;
    public static byte REPORT_INVALID_OLDER = (byte)2;
    public static byte REPORT_INVALID_NEWER = (byte)3;
    private static Log LOG = LogFactory.getLog(ReportUtil.class);

    public static Report loadConvertedReport(InputStream is) {
        XStream xstream = XStreamFactory.createXStream();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(is, "UTF-8");
            return (Report)xstream.fromXML((Reader)reader);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public static Report loadConvertedReport(String xml) {
        XStream xstream = XStreamFactory.createXStream();
        try {
            return (Report)xstream.fromXML(xml);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public static Report loadReport(String xml) throws LoadReportException {
        try {
            String convertedXml = ConverterChain.applyFromXml(xml);
            XStream xstream = XStreamFactory.createXStream();
            return (Report)xstream.fromXML(convertedXml);
        }
        catch (ConverterException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            throw new LoadReportException(ex.getMessage(), ex);
        }
    }

    public static Report loadReport(InputStream is) throws LoadReportException {
        try {
            String xml = ReportUtil.readAsString(is);
            String convertedXml = ConverterChain.applyFromXml(xml);
            XStream xstream = XStreamFactory.createXStream();
            return (Report)xstream.fromXML(convertedXml);
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            throw new LoadReportException(ex.getMessage(), ex);
        }
    }

    public static void saveReport(Report report, OutputStream out) {
        XStream xstream = XStreamFactory.createXStream();
        xstream.toXML((Object)report, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveReport(Report report, String path) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(path);
            ReportUtil.saveReport(report, fos);
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveReport(String xml, String path) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(path);
            fos.write(xml.getBytes("UTF-8"));
            fos.flush();
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String reportToXml(Report report) {
        XStream xstream = XStreamFactory.createXStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        xstream.toXML((Object)report, (OutputStream)bos);
        return bos.toString();
    }

    public static byte isValidReportVersion(byte[] reportContent) {
        String reportVersion = ReportUtil.getVersion(reportContent);
        return ReportUtil.isValid(reportVersion);
    }

    public static byte isValidReportVersion(Report report) {
        String reportVersion = report.getVersion();
        return ReportUtil.isValid(reportVersion);
    }

    public static byte isValidReportVersion(String reportFile) {
        String reportVersion = ReportUtil.getVersion(reportFile);
        return ReportUtil.isValid(reportVersion);
    }

    public static byte isValid(String reportVersion) {
        if (ReportUtil.isOlderUnsupportedVersion(reportVersion)) {
            return REPORT_INVALID_OLDER;
        }
        if (ReportUtil.isNewerUnsupportedVersion(reportVersion)) {
            return REPORT_INVALID_NEWER;
        }
        return REPORT_VALID;
    }

    public static boolean isOlderUnsupportedVersion(String version) {
        return version == null || "".equals(version) || version.startsWith("0") || version.startsWith("1");
    }

    public static boolean isNewerUnsupportedVersion(String version) {
        if (version == null || "".equals(version)) {
            return true;
        }
        String engineVersion = ReleaseInfoAdapter.getVersionNumber();
        String[] ev = engineVersion.split("\\.");
        String[] rv = version.split("\\.");
        return Integer.parseInt(ev[0]) < Integer.parseInt(rv[0]) || Integer.parseInt(ev[0]) == Integer.parseInt(rv[0]) && Integer.parseInt(ev[1]) < Integer.parseInt(rv[1]);
    }

    public static int compareVersions(String v1, String v2) {
        String[] v1a = v1.split("\\.");
        String[] v2a = v2.split("\\.");
        Integer v1M = Integer.parseInt(v1a[0]);
        Integer v2M = Integer.parseInt(v2a[0]);
        if (v1M < v2M) {
            return -1;
        }
        if (v1M > v2M) {
            return 1;
        }
        Integer v1min = Integer.parseInt(v1a[1]);
        Integer v2min = Integer.parseInt(v2a[1]);
        if (v1min < v2min) {
            return -1;
        }
        if (v1min > v2min) {
            return 1;
        }
        return 0;
    }

    public static String getVersion(String reportFile) {
        try {
            String text = ReportUtil.readAsString(reportFile);
            return ReportUtil.getVersionFromText(text);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getVersion(InputStream is) {
        try {
            String text = ReportUtil.readAsString(is);
            return ReportUtil.getVersionFromText(text);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getVersion(byte[] reportContent) {
        String text = new String(reportContent);
        return ReportUtil.getVersionFromText(text);
    }

    public static String getVersionFromText(String reportText) {
        String start = "<report version=\"";
        int index = reportText.indexOf(start);
        if (index == -1) {
            return null;
        }
        int lastIndex = reportText.indexOf("\"", index += start.length());
        if (lastIndex == -1) {
            return null;
        }
        return reportText.substring(index, lastIndex);
    }

    public static String readAsString(String reportPath) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(reportPath));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            fileData.append(buf, 0, numRead);
        }
        reader.close();
        return fileData.toString();
    }

    public static String readAsString(InputStream is) throws IOException {
        try {
            return new Scanner(is, "UTF-8").useDelimiter("\\A").next();
        }
        catch (NoSuchElementException e) {
            return "";
        }
    }

    public static String getFileName(String filePath) {
        if (filePath == null) {
            return filePath;
        }
        int index = filePath.lastIndexOf(File.separator);
        if (index == -1) {
            return filePath;
        }
        return filePath.substring(index + 1);
    }

    public static List<String> getStaticImages(Report report) {
        ArrayList<String> images = new ArrayList<String>();
        ReportLayout layout = report.getLayout();
        List<Band> bands = layout.getBands();
        for (Band band : bands) {
            int rows = band.getRowCount();
            for (int i = 0; i < rows; ++i) {
                List<BandElement> list = band.getRow(i);
                for (BandElement be : list) {
                    if (!(be instanceof ImageBandElement) || be instanceof ChartBandElement || be instanceof BarcodeBandElement) continue;
                    images.add(((ImageBandElement)be).getImage());
                }
            }
        }
        if (layout.getBackgroundImage() != null) {
            images.add(layout.getBackgroundImage());
        }
        return images;
    }

    public static String getSql(Report report) {
        String sql = report.getSql() != null ? report.getSql() : report.getQuery().toString();
        return sql;
    }

    public static String getSql(Report report, Map<String, Object> parameterValues) {
        SimpleDateFormat timeFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        SimpleDateFormat dayFormat = new SimpleDateFormat("dd/MM/yyyy");
        String sql = ReportUtil.getSql(report);
        if (parameterValues != null) {
            for (String pName : parameterValues.keySet()) {
                Object value = parameterValues.get(pName);
                StringBuilder text = new StringBuilder();
                if (value == null) {
                    text.append("null");
                    continue;
                }
                if (value instanceof Object[]) {
                    Object[] values = (Object[])value;
                    text.append("(");
                    int size = values.length;
                    for (int i = 0; i < size; ++i) {
                        Object obj = values[i];
                        if (obj instanceof IdName) {
                            text.append(((IdName)obj).getId());
                        } else if (obj instanceof Date) {
                            text.append(dayFormat.format((Date)obj));
                        } else if (obj instanceof Timestamp) {
                            Date date = new Date(((Timestamp)obj).getTime());
                            text.append(timeFormat.format(date));
                        } else {
                            text.append(obj);
                        }
                        if (i >= size - 1) continue;
                        text.append(",");
                    }
                    text.append(")");
                } else if (value instanceof IdName) {
                    Serializable idName = ((IdName)value).getId();
                    if (idName instanceof String) {
                        text.append("'");
                        text.append(value);
                        text.append("'");
                    } else {
                        text.append(value);
                    }
                } else if (value instanceof Date) {
                    text.append("'");
                    text.append(dayFormat.format((Date)value));
                    text.append("'");
                } else if (value instanceof Timestamp) {
                    text.append("'");
                    Date date = new Date(((Timestamp)value).getTime());
                    text.append(timeFormat.format(date));
                    text.append("'");
                } else if (value instanceof String) {
                    text.append("'");
                    text.append(value);
                    text.append("'");
                } else {
                    text.append(value);
                }
                String tag = "${" + pName + "}";
                while (sql.indexOf(tag) != -1) {
                    int index = sql.indexOf(tag);
                    sql = sql.substring(0, index) + text.toString() + sql.substring(index + tag.length());
                }
            }
        }
        return sql;
    }

    public static List<ExpressionBean> getExpressions(ReportLayout layout) {
        LinkedList<ExpressionBean> expressions = new LinkedList<ExpressionBean>();
        for (Band band : layout.getBands()) {
            int rows = band.getRowCount();
            for (int i = 0; i < rows; ++i) {
                List<BandElement> list = band.getRow(i);
                for (BandElement be : list) {
                    if (!(be instanceof ExpressionBandElement) || expressions.contains((ExpressionBandElement)be)) continue;
                    expressions.add(new ExpressionBean((ExpressionBandElement)be, band.getName()));
                }
            }
        }
        return expressions;
    }

    public static List<ExpressionBean> getExpressions(ReportLayout layout, String bandName) {
        LinkedList<ExpressionBean> expressions = new LinkedList<ExpressionBean>();
        for (Band band : layout.getBands()) {
            if (!band.getName().equals(bandName)) continue;
            int rows = band.getRowCount();
            for (int i = 0; i < rows; ++i) {
                List<BandElement> list = band.getRow(i);
                for (BandElement be : list) {
                    if (!(be instanceof ExpressionBandElement) || expressions.contains((ExpressionBandElement)be)) continue;
                    expressions.add(new ExpressionBean((ExpressionBandElement)be, band.getName()));
                }
            }
        }
        return expressions;
    }

    public static List<String> getExpressionsNames(ReportLayout layout) {
        LinkedList<String> expressions = new LinkedList<String>();
        for (Band band : layout.getBands()) {
            int rows = band.getRowCount();
            for (int i = 0; i < rows; ++i) {
                List<BandElement> list = band.getRow(i);
                for (BandElement be : list) {
                    String expName;
                    if (!(be instanceof ExpressionBandElement) || expressions.contains(expName = ((ExpressionBandElement)be).getExpressionName())) continue;
                    expressions.add(expName);
                }
            }
        }
        return expressions;
    }

    public static boolean isValidSql(Connection con, Report report) {
        return ReportUtil.isValidSqlWithMessage(con, report) == null;
    }

    public static String isValidSqlWithMessage(Connection con, Report report) {
        List<QueryParameter> parameters;
        String sql = ReportUtil.getSql(report);
        String message = ReportUtil.isValidSqlWithMessage(con, sql, parameters = report.getParameters());
        if (message == null) {
            for (QueryParameter qp : parameters) {
                String parMessage;
                if (!qp.isManualSource() || (parMessage = ReportUtil.isValidSqlWithMessage(con, qp.getSource(), parameters)) == null) continue;
                parMessage = "Parameter '" + qp.getName() + "'\n" + parMessage;
                return parMessage;
            }
        }
        return message;
    }

    public static String isValidSqlWithMessage(Connection con, String sql, List<QueryParameter> parameters) {
        try {
            QueryUtil qu = new QueryUtil(con, DialectUtil.getDialect(con));
            HashMap<String, QueryParameter> params = new HashMap<String, QueryParameter>();
            for (QueryParameter qp : parameters) {
                params.put(qp.getName(), qp);
            }
            qu.getColumnNames(sql, params);
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            return ex.getMessage();
        }
        return null;
    }

    public static List<Report> getSubreports(Report report) {
        ArrayList<Report> subreports = new ArrayList<Report>();
        List<Band> bands = report.getLayout().getDocumentBands();
        for (Band band : bands) {
            int rows = band.getRowCount();
            for (int i = 0; i < rows; ++i) {
                List<BandElement> list = band.getRow(i);
                int size = list.size();
                for (int j = 0; j < size; ++j) {
                    BandElement be = list.get(j);
                    if (!(be instanceof ReportBandElement)) continue;
                    subreports.add(((ReportBandElement)be).getReport());
                }
            }
        }
        return subreports;
    }

    public static List<Report> getDetailSubreports(ReportLayout reportLayout) {
        ArrayList<Report> subreports = new ArrayList<Report>();
        Band band = reportLayout.getDetailBand();
        int rows = band.getRowCount();
        for (int i = 0; i < rows; ++i) {
            List<BandElement> list = band.getRow(i);
            int size = list.size();
            for (int j = 0; j < size; ++j) {
                BandElement be = list.get(j);
                if (!(be instanceof ReportBandElement)) continue;
                subreports.add(((ReportBandElement)be).getReport());
            }
        }
        return subreports;
    }

    public static List<Chart> getDetailCharts(ReportLayout reportLayout) {
        ArrayList<Chart> charts = new ArrayList<Chart>();
        Band band = reportLayout.getDetailBand();
        int rows = band.getRowCount();
        for (int i = 0; i < rows; ++i) {
            List<BandElement> list = band.getRow(i);
            int size = list.size();
            for (int j = 0; j < size; ++j) {
                BandElement be = list.get(j);
                if (!(be instanceof ChartBandElement)) continue;
                charts.add(((ChartBandElement)be).getChart());
            }
        }
        return charts;
    }

    public static boolean isGroupBand(String bandName) {
        if (bandName == null) {
            return false;
        }
        return bandName.startsWith("Group_Header") || bandName.startsWith("Group_Footer");
    }

    public static boolean isDetailBand(String bandName) {
        if (bandName == null) {
            return false;
        }
        return bandName.equals("Detail");
    }

    public static boolean isPageHeaderBand(String bandName) {
        if (bandName == null) {
            return false;
        }
        return bandName.equals("PageHeader");
    }

    private static ReportLayout getForReportLayout(Connection con, ReportLayout layout, ParametersBean pBean) throws Exception {
        ReportLayout convertedLayout = ObjectCloner.silenceDeepCopy(layout);
        List<Band> bands = convertedLayout.getDocumentBands();
        for (Band band : bands) {
            int rows = band.getRowCount();
            for (int i = 0; i < rows; ++i) {
                List<BandElement> list = band.getRow(i);
                int size = list.size();
                for (int j = 0; j < size; ++j) {
                    int m;
                    BandElement be = list.get(j);
                    if (!(be instanceof ForReportBandElement)) continue;
                    String sql = ((ForReportBandElement)be).getSql();
                    Report report = ((ForReportBandElement)be).getReport();
                    if (sql == null || sql.isEmpty()) {
                        return convertedLayout;
                    }
                    QueryUtil qu = new QueryUtil(con, DialectUtil.getDialect(con));
                    String columnName = qu.getColumnNames(sql, pBean.getParams()).get(0);
                    List<IdName> values = qu.getValues(sql, pBean.getParams(), pBean.getParamValues());
                    int pos = j;
                    for (int k = 0; k < values.size(); ++k) {
                        IdName in = values.get(k);
                        if (k > 0) {
                            band.insertColumn(pos);
                        }
                        Report newReport = ObjectCloner.silenceDeepCopy(report);
                        ReportLayout subReportLayout = ReportUtil.getReportLayoutForHeaderFunctions(newReport.getLayout());
                        newReport.setLayout(subReportLayout);
                        newReport.setName(report.getBaseName() + "_" + (k + 1) + ".report");
                        newReport.getGeneratedParamValues().put(columnName, in.getId());
                        band.setElementAt(new ReportBandElement(newReport), i, pos);
                        ++pos;
                    }
                    List<Integer> oldColumnsWidth = layout.getColumnsWidth();
                    ArrayList<Integer> newColumnWidth = new ArrayList<Integer>();
                    for (m = 0; m < j; ++m) {
                        newColumnWidth.add(oldColumnsWidth.get(m));
                    }
                    for (m = 0; m < values.size(); ++m) {
                        newColumnWidth.add(oldColumnsWidth.get(j));
                    }
                    for (m = j + 1; m < size; ++m) {
                        newColumnWidth.add(oldColumnsWidth.get(m));
                    }
                    convertedLayout.setColumnsWidth(newColumnWidth);
                    return convertedLayout;
                }
            }
        }
        return convertedLayout;
    }

    private static ReportLayout getReportLayoutForHeaderFunctions(ReportLayout layout) {
        ReportLayout convertedLayout = ObjectCloner.silenceDeepCopy(layout);
        List<FunctionBandElement> headerFunc = ReportUtil.getHeaderFunctions(convertedLayout);
        Band footerBand = convertedLayout.getFooterBand();
        ReportUtil.insertFunctionsInFooterBands(headerFunc, footerBand, convertedLayout.getColumnCount());
        List<ReportGroup> groups = convertedLayout.getGroups();
        for (ReportGroup rg : groups) {
            List<FunctionBandElement> groupHeaderFunc = ReportUtil.getGroupHeaderFunctions(convertedLayout, rg.getName());
            Band gBand = convertedLayout.getBand("Group_Footer" + rg.getName());
            ReportUtil.insertFunctionsInFooterBands(groupHeaderFunc, gBand, convertedLayout.getColumnCount());
        }
        return convertedLayout;
    }

    public static ReportLayout getDynamicReportLayout(Connection con, ReportLayout layout, ParametersBean pBean) throws Exception {
        ReportLayout convertedLayout = ReportUtil.getReportLayoutForHeaderFunctions(layout);
        ReportLayout forConvertedLayout = ReportUtil.getForReportLayout(con, convertedLayout, pBean);
        return forConvertedLayout;
    }

    public static boolean foundFunctionInHeader(ReportLayout layout) {
        Band header = layout.getHeaderBand();
        return ReportUtil.foundFunctionInBand(header);
    }

    public static boolean foundFunctionInGroupHeader(ReportLayout layout, String groupName) {
        List<Band> groupHeaderBands = layout.getGroupHeaderBands();
        for (Band band : groupHeaderBands) {
            if (!band.getName().equals("Group_Header" + groupName)) continue;
            return ReportUtil.foundFunctionInBand(band);
        }
        return false;
    }

    public static boolean foundFunctionInAnyGroupHeader(ReportLayout layout) {
        List<Band> groupHeaderBands = layout.getGroupHeaderBands();
        for (Band band : groupHeaderBands) {
            boolean found = ReportUtil.foundFunctionInBand(band);
            if (!found) continue;
            return true;
        }
        return false;
    }

    private static boolean foundFunctionInBand(Band band) {
        int size = band.getRowCount();
        for (int i = 0; i < size; ++i) {
            List<BandElement> elements = band.getRow(i);
            for (BandElement be : elements) {
                if (be instanceof FunctionBandElement) {
                    return true;
                }
                if (!(be instanceof ExpressionBandElement) || !((ExpressionBandElement)be).getExpression().contains("$F")) continue;
                return true;
            }
        }
        return false;
    }

    private static List<FunctionBandElement> getHeaderFunctions(ReportLayout layout) {
        ArrayList<FunctionBandElement> result = new ArrayList<FunctionBandElement>();
        Band header = layout.getHeaderBand();
        int size = header.getRowCount();
        for (int i = 0; i < size; ++i) {
            List<BandElement> elements = header.getRow(i);
            for (BandElement be : elements) {
                if (!(be instanceof FunctionBandElement)) continue;
                result.add(ObjectCloner.silenceDeepCopy((FunctionBandElement)be));
            }
        }
        return result;
    }

    private static List<FunctionBandElement> getGroupHeaderFunctions(ReportLayout layout, String groupName) {
        ArrayList<FunctionBandElement> result = new ArrayList<FunctionBandElement>();
        List<Band> groupHeaderBands = layout.getGroupHeaderBands();
        for (Band band : groupHeaderBands) {
            if (!band.getName().equals("Group_Header" + groupName)) continue;
            int size = band.getRowCount();
            for (int i = 0; i < size; ++i) {
                List<BandElement> elements = band.getRow(i);
                for (BandElement be : elements) {
                    if (!(be instanceof FunctionBandElement)) continue;
                    result.add(ObjectCloner.silenceDeepCopy((FunctionBandElement)be));
                }
            }
            return result;
        }
        return result;
    }

    private static void insertFunctionsInFooterBands(List<FunctionBandElement> functions, Band band, int cols) {
        for (FunctionBandElement fbe : functions) {
            if (band.getRowCount() == 0) {
                band.insertFirstRow(0, cols);
            } else {
                band.insertRow(0);
            }
            fbe.setHideWhenExpression("1 > 0");
            band.getRow(0).set(0, fbe);
        }
    }

    public static List<FunctionBandElement> getFunctionsFromExpression(String expression) {
        ArrayList<FunctionBandElement> result = new ArrayList<FunctionBandElement>();
        String regex = "[^\\$]*\\$F_([^_\\$]+)_([^_\\$\\s\\.\\+\\*/-]+)[^\\$]*";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(expression);
        while (m.find()) {
            String function = m.group(1);
            String column = m.group(2);
            FunctionBandElement fbe = new FunctionBandElement(function, column);
            result.add(fbe);
        }
        return result;
    }

    public static List<String> getKeys(ReportLayout layout) {
        ArrayList<String> result = new ArrayList<String>();
        List<Band> bands = layout.getBands();
        for (Band band : bands) {
            int size = band.getRowCount();
            for (int i = 0; i < size; ++i) {
                List<BandElement> elements = band.getRow(i);
                for (BandElement be : elements) {
                    String pattern;
                    if (be == null) continue;
                    if (be.getText().contains("@@")) {
                        result.add(StringUtil.getKey(be.getText()));
                    }
                    if (!(be instanceof FieldBandElement) || (pattern = ((FieldBandElement)be).getPattern()) == null || pattern.indexOf("@@") == -1) continue;
                    result.add(StringUtil.getKey(pattern));
                }
            }
        }
        return result;
    }

    public static List<String> getColumnNames(List<NameType> columns) {
        ArrayList<String> names = new ArrayList<String>();
        for (NameType nt : columns) {
            names.add(nt.getName());
        }
        return names;
    }

    public static List<String> getColumnTypes(List<NameType> columns) {
        ArrayList<String> types = new ArrayList<String>();
        for (NameType nt : columns) {
            types.add(nt.getType());
        }
        return types;
    }
}

