/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.util;

import com.thoughtworks.xstream.core.util.Base64Encoder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.nextreports.engine.exporter.util.RomanNumberConverter;
import ro.nextreports.engine.i18n.I18nLanguage;
import ro.nextreports.engine.i18n.I18nUtil;
import ro.nextreports.engine.queryexec.IdName;
import ro.nextreports.engine.util.PrefixSuffix;

public class StringUtil {
    public static String BLOB = "blob";

    public static String capitalize(String str) {
        StringBuilder sb = new StringBuilder();
        char prevCh = '.';
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (Character.isLetter(ch) && !Character.isLetter(prevCh)) {
                sb.append(Character.toUpperCase(ch));
            } else {
                sb.append(ch);
            }
            prevCh = ch;
        }
        return sb.toString();
    }

    public static void replaceInFile(File file, String oldText, String newText) {
        StringUtil.replaceInFile(file, oldText, newText, true);
    }

    public static void replaceInFile(File file, String oldText, String newText, boolean casesensitive) {
        Pattern p = casesensitive ? Pattern.compile(oldText) : Pattern.compile(oldText, 2);
        Matcher m = p.matcher(StringUtil.getContents(file));
        StringBuffer sb = new StringBuffer();
        boolean result = m.find();
        while (result) {
            m.appendReplacement(sb, newText);
            result = m.find();
        }
        m.appendTail(sb);
        StringUtil.setContents(file, sb.toString());
    }

    public static String replace(String text, String oldText, String newText) {
        if (newText == null) {
            return text;
        }
        Pattern p = Pattern.compile(oldText);
        Matcher m = p.matcher(text);
        StringBuffer sb = new StringBuffer();
        boolean result = m.find();
        while (result) {
            m.appendReplacement(sb, newText);
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(File aFile) {
        StringBuilder contents = new StringBuilder();
        try (BufferedReader input = new BufferedReader(new FileReader(aFile));){
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return contents.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContents(File file, String content) {
        try (BufferedWriter output = new BufferedWriter(new FileWriter(file));){
            output.write(content);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String getFirstDuplicateValue(List<String> values) {
        String message = null;
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            String col1 = values.get(i);
            for (int j = i + 1; j < size; ++j) {
                String col2 = values.get(j);
                if (!col1.equals(col2)) continue;
                message = col1;
                return message;
            }
        }
        return message;
    }

    public static boolean isFileName(String s) {
        if (s == null) {
            return false;
        }
        if (s.startsWith(" ") || s.startsWith(".")) {
            return false;
        }
        if (s.endsWith(" ") || s.endsWith(".")) {
            return false;
        }
        String regex = "[^\\\\/:*?\\\"<>|%]+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(s);
        return matcher.matches();
    }

    public static String getValueAsString(Object val, String pattern) {
        return StringUtil.getValueAsString(val, pattern, null);
    }

    public static String getValueAsString(Object val, String pattern, I18nLanguage lang) {
        return StringUtil.getValueAsString(val, pattern, lang, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getValueAsString(Object val, String pattern, I18nLanguage lang, String parameterValueClass) {
        Date d;
        if (val == null) {
            return null;
        }
        if (val instanceof IdName) {
            IdName in = (IdName)val;
            val = in.getName() == null || in.getId().equals(in.getName()) ? in.getId() : in.getName();
        }
        if (val instanceof String) {
            return (String)val;
        }
        if (pattern != null && pattern.contains("@@") && lang != null) {
            pattern = StringUtil.getI18nString(pattern, lang);
        }
        if (val instanceof Number) {
            if (pattern == null) {
                return NumberFormat.getNumberInstance().format(((Number)val).doubleValue());
            }
            if ("MCMLXXXVII".equals(pattern)) {
                return RomanNumberConverter.romanize(((Number)val).intValue());
            }
            DecimalFormat df = new DecimalFormat(pattern);
            return df.format(((Number)val).doubleValue());
        }
        if (val instanceof Time) {
            if (pattern == null) {
                return DateFormat.getTimeInstance().format((Time)val);
            }
            d = (Time)val;
            SimpleDateFormat sfd = new SimpleDateFormat(pattern);
            return sfd.format(d);
        }
        if (val instanceof Timestamp) {
            if (pattern == null) {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Timestamp)val);
            }
            d = (Timestamp)val;
            SimpleDateFormat sfd = new SimpleDateFormat(pattern);
            return sfd.format(d);
        }
        if (val instanceof Date) {
            if (pattern == null) {
                if (parameterValueClass != null) {
                    if (parameterValueClass.equals("java.sql.Time")) {
                        return new SimpleDateFormat("HH:mm:ss").format((Date)val);
                    }
                    if (parameterValueClass.equals("java.sql.Timestamp")) {
                        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)val);
                    }
                    return new SimpleDateFormat("yyyy-MM-dd").format((Date)val);
                }
                return DateFormat.getDateInstance().format((Date)val);
            }
            SimpleDateFormat sfd = new SimpleDateFormat(pattern);
            return sfd.format((Date)val);
        }
        if (val instanceof Clob) {
            Clob clob = (Clob)val;
            InputStream is = null;
            OutputStream os = null;
            try {
                int read;
                is = clob.getAsciiStream();
                byte[] buffer = new byte[4096];
                os = new ByteArrayOutputStream();
                while ((read = is.read(buffer)) != -1) {
                    os.write(buffer, 0, read);
                }
                String string = os.toString();
                return string;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                String string = "clob exception";
                return string;
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (val instanceof Blob) {
            Blob blob = (Blob)val;
            try {
                byte[] bytes = blob.getBytes(1L, (int)blob.length());
                String hex = StringUtil.byteArrayToHex(bytes);
                if (StringUtil.isImage(hex)) {
                    String ret = StringUtil.encodeImage(bytes);
                    return ret;
                }
                return BLOB;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return val.toString();
    }

    public static boolean equalsText(String s1, String s2) {
        if (s1 == null ? s2 != null : s2 == null) {
            return false;
        }
        return s1 == null || s2 == null || (s1 = s1.replaceAll("\\s", "").toLowerCase()).equals(s2 = s2.replaceAll("\\s", "").toLowerCase());
    }

    public static PrefixSuffix parse(String s, String search) {
        if (s == null) {
            return null;
        }
        int index = s.indexOf(search);
        if (index != -1) {
            String prefix = "";
            String suffix = "";
            if (index > 0) {
                prefix = s.substring(0, index);
            }
            if (prefix.length() + search.length() < s.length()) {
                suffix = s.substring(index + search.length());
            }
            return new PrefixSuffix(prefix, suffix);
        }
        return null;
    }

    public static String encodeImage(byte[] imageByteArray) {
        return new Base64Encoder().encode(imageByteArray);
    }

    public static byte[] decodeImage(String imageDataString) {
        return new Base64Encoder().decode(imageDataString);
    }

    private static boolean isImage(String hexString) {
        boolean isImage = false;
        if (hexString.startsWith("89504e470d0a1a0a")) {
            isImage = true;
        } else if (hexString.startsWith("474946383761") || hexString.startsWith("474946383961")) {
            isImage = true;
        } else if (hexString.startsWith("ffd8ffe0")) {
            isImage = true;
        }
        return isImage;
    }

    private static String byteArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder();
        for (byte b : a) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString().toLowerCase();
    }

    public static String getI18nString(String s, I18nLanguage lang) {
        int index = s.indexOf("@@");
        if (index == -1) {
            return s;
        }
        String s2 = s.substring(index + "@@".length());
        int index2 = s2.indexOf("@@");
        if (index2 == -1) {
            return s;
        }
        String key = s2.substring(0, index2);
        if (lang == null) {
            return s;
        }
        String newValue = I18nUtil.getString(key, lang);
        if ("".equals(newValue.trim())) {
            return s;
        }
        return s.substring(0, index) + I18nUtil.getString(key, lang) + s2.substring(index2 + "@@".length());
    }

    public static String getI18nStringMultiple(String s, I18nLanguage lang) {
        String oldS;
        s = StringUtil.getI18nString(s, lang);
        while (s.contains("@@") && !(oldS = s).equals(s = StringUtil.getI18nString(s, lang))) {
        }
        return s;
    }

    public static String getKey(String s) {
        int index = s.indexOf("@@");
        if (index == -1) {
            return null;
        }
        String s2 = s.substring(index + "@@".length());
        int index2 = s2.indexOf("@@");
        if (index2 == -1) {
            return null;
        }
        return s2.substring(0, index2);
    }

    public static List<String> getKeys(String s) {
        String s2;
        int index2;
        ArrayList<String> result = new ArrayList<String>();
        if (s == null) {
            return result;
        }
        int index = s.indexOf("@@");
        while (index != -1 && (index2 = (s2 = s.substring(index + "@@".length())).indexOf("@@")) != -1) {
            result.add(s2.substring(0, index2));
            s = s2.substring(index2 + "@@".length());
            index = s.indexOf("@@");
        }
        return result;
    }
}

