/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ro.nextreports.engine.util.DateUtil;

public class TimeShortcutType
implements Serializable {
    private int type;
    private int timeType;
    private int timeUnits;
    private static final long serialVersionUID = -3081236915067313721L;
    public static final int DAY_TYPE = 6;
    public static final int WEEK_TYPE = 3;
    public static final int MONTH_TYPE = 2;
    public static final int YEAR_TYPE = 1;
    public static TimeShortcutType NONE = new TimeShortcutType(0);
    public static TimeShortcutType YESTERDAY = new TimeShortcutType(1);
    public static TimeShortcutType TODAY = new TimeShortcutType(2);
    public static TimeShortcutType PREVIOUS_WEEK = new TimeShortcutType(3);
    public static TimeShortcutType CURRENT_WEEK = new TimeShortcutType(4);
    public static TimeShortcutType PREVIOUS_MONTH = new TimeShortcutType(5);
    public static TimeShortcutType CURRENT_MONTH = new TimeShortcutType(6);
    public static TimeShortcutType PREVIOUS_YEAR = new TimeShortcutType(7);
    public static TimeShortcutType CURRENT_YEAR = new TimeShortcutType(8);
    public static TimeShortcutType LAST = new TimeShortcutType(-1);

    public TimeShortcutType(int type) {
        this.type = type;
        this.timeType = 0;
        this.timeUnits = 0;
    }

    public TimeShortcutType(int timeType, int timeUnits) {
        this.type = -1;
        this.timeType = timeType;
        this.timeUnits = timeUnits;
    }

    public boolean isUnitsType() {
        return this.type == -1;
    }

    public int getType() {
        return this.type;
    }

    public int getTimeType() {
        return this.timeType;
    }

    public int getTimeUnits() {
        return this.timeUnits;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.timeType;
        result = 31 * result + this.timeUnits;
        result = 31 * result + this.type;
        return result;
    }

    public Date[] getDates() {
        if (this.type == 0) {
            return new Date[0];
        }
        Date currentDate = new Date();
        Date[] dates = new Date[2];
        switch (this.type) {
            case -1: {
                dates[0] = DateUtil.getLastNDay(currentDate, this.timeUnits, this.timeType);
                dates[1] = DateUtil.ceil(currentDate);
                break;
            }
            case 1: {
                Date yesterday = DateUtil.addDays(currentDate, -1);
                dates[0] = DateUtil.floor(yesterday);
                dates[1] = DateUtil.ceil(yesterday);
                break;
            }
            case 2: {
                dates[0] = DateUtil.floor(currentDate);
                dates[1] = DateUtil.ceil(currentDate);
                break;
            }
            case 3: {
                dates[0] = DateUtil.getFirstDayFromLastWeek(currentDate);
                dates[1] = DateUtil.getLastDayFromLastWeek(currentDate);
                break;
            }
            case 4: {
                dates[0] = DateUtil.getFirstDayFromCurrentWeek(currentDate);
                dates[1] = DateUtil.getLastDayFromCurrentWeek(currentDate);
                break;
            }
            case 5: {
                dates[0] = DateUtil.getFirstDayFromLastMonth(currentDate);
                dates[1] = DateUtil.getLastDayFromLastMonth(currentDate);
                break;
            }
            case 6: {
                dates[0] = DateUtil.getFirstDayFromCurrentMonth(currentDate);
                dates[1] = DateUtil.getLastDayFromCurrentMonth(currentDate);
                break;
            }
            case 7: {
                dates[0] = DateUtil.getFirstDayFromLastYear(currentDate);
                dates[1] = DateUtil.getLastDayFromLastYear(currentDate);
                break;
            }
            case 8: {
                dates[0] = DateUtil.getFirstDayFromCurrentYear(currentDate);
                dates[1] = DateUtil.getLastDayFromCurrentYear(currentDate);
                break;
            }
            default: {
                dates[0] = dates[1] = currentDate;
            }
        }
        return dates;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeShortcutType other = (TimeShortcutType)obj;
        if (this.timeType != other.timeType) {
            return false;
        }
        if (this.timeUnits != other.timeUnits) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "TimeShortcutType [type=" + this.type + ", timeType=" + this.timeType + ", timeUnits=" + this.timeUnits + "]";
    }

    public static void main(String[] args) {
        Date[] date = YESTERDAY.getDates();
        System.out.println("Yesterday = [" + date[0] + " , " + date[1] + "]");
        date = TODAY.getDates();
        System.out.println("Today = [" + date[0] + " , " + date[1] + "]");
        date = PREVIOUS_WEEK.getDates();
        System.out.println("Previous week = [" + date[0] + " , " + date[1] + "]");
        date = CURRENT_WEEK.getDates();
        System.out.println("Current week = [" + date[0] + " , " + date[1] + "]");
        date = PREVIOUS_MONTH.getDates();
        System.out.println("Previous month = [" + date[0] + " , " + date[1] + "]");
        date = CURRENT_MONTH.getDates();
        System.out.println("Current month = [" + date[0] + " , " + date[1] + "]");
        date = PREVIOUS_YEAR.getDates();
        System.out.println("Previous year = [" + date[0] + " , " + date[1] + "]");
        date = CURRENT_YEAR.getDates();
        System.out.println("Current year = [" + date[0] + " , " + date[1] + "]");
        date = new TimeShortcutType(6, 5).getDates();
        System.out.println("Last 5 days = [" + date[0] + " , " + date[1] + "]");
        date = new TimeShortcutType(3, 2).getDates();
        System.out.println("Last 2 weeks = [" + date[0] + " , " + date[1] + "]");
        date = new TimeShortcutType(2, 3).getDates();
        System.out.println("Last 3 months = [" + date[0] + " , " + date[1] + "]");
        date = new TimeShortcutType(1, 1).getDates();
        System.out.println("Last 1 years = [" + date[0] + " , " + date[1] + "]");
    }

    public static List<TimeShortcutType> getTypes() {
        ArrayList<TimeShortcutType> result = new ArrayList<TimeShortcutType>();
        result.add(NONE);
        result.add(YESTERDAY);
        result.add(TODAY);
        result.add(PREVIOUS_WEEK);
        result.add(CURRENT_WEEK);
        result.add(PREVIOUS_MONTH);
        result.add(CURRENT_MONTH);
        result.add(PREVIOUS_YEAR);
        result.add(CURRENT_YEAR);
        result.add(LAST);
        return result;
    }

    public static String getName(int type) {
        switch (type) {
            case -1: {
                return "Last";
            }
            case 0: {
                return "None";
            }
            case 1: {
                return "Yesterday";
            }
            case 2: {
                return "Today";
            }
            case 3: {
                return "PreviousWeek";
            }
            case 4: {
                return "CurrentWeek";
            }
            case 5: {
                return "PreviousMonth";
            }
            case 6: {
                return "CurrentMonth";
            }
            case 7: {
                return "PreviousYear";
            }
            case 8: {
                return "CurrentYear";
            }
        }
        return "NA";
    }

    public static String getTypeName(int typeUnit) {
        switch (typeUnit) {
            case 6: {
                return "Days";
            }
            case 3: {
                return "Weeks";
            }
            case 2: {
                return "Months";
            }
            case 1: {
                return "Years";
            }
        }
        return "NA";
    }

    public static int getTypeUnit(String typeName) {
        if ("Days".equals(typeName)) {
            return 6;
        }
        if ("Weeks".equals(typeName)) {
            return 3;
        }
        if ("Months".equals(typeName)) {
            return 2;
        }
        if ("Years".equals(typeName)) {
            return 1;
        }
        return -1;
    }

    public static List<String> getTypeNames() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Days");
        result.add("Weeks");
        result.add("Months");
        result.add("Years");
        return result;
    }
}

