/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.util.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import ro.nextreports.engine.ReleaseInfoAdapter;
import ro.nextreports.engine.Report;
import ro.nextreports.engine.util.ReportUtil;
import ro.nextreports.engine.util.converter.ConverterException;
import ro.nextreports.engine.util.converter.NextConverter;

public abstract class AbstractNextConverter
implements NextConverter {
    private static Log LOG = LogFactory.getLog(AbstractNextConverter.class);
    private boolean dirty = false;

    @Override
    public String convertFromPath(String reportPath, boolean changeVersion) throws ConverterException {
        try {
            String text = ReportUtil.readAsString(reportPath);
            return this.convert(text, "'" + reportPath + "'", changeVersion);
        }
        catch (IOException ex) {
            throw new ConverterException("Converter " + this.getConverterVersion() + " : " + ex.getMessage());
        }
    }

    @Override
    public String convertFromInputStream(InputStream is, boolean changeVersion) throws ConverterException {
        try {
            String text = ReportUtil.readAsString(is);
            return this.convert(text, "from input stream", changeVersion);
        }
        catch (IOException ex) {
            throw new ConverterException("Converter " + this.getConverterVersion() + " : " + ex.getMessage());
        }
    }

    @Override
    public String convertFromXml(String xml, boolean changeVersion) throws ConverterException {
        return this.convert(xml, "from xml", changeVersion);
    }

    private String convert(String text, String message, boolean changeVersion) throws ConverterException {
        try {
            this.dirty = false;
            String version = ReportUtil.getVersionFromText(text);
            if (version == null) {
                throw new ConverterException("Converter " + this.getConverterVersion() + " : Could not read version for report " + message);
            }
            if (ReportUtil.compareVersions(version, this.getConverterVersion()) >= 0) {
                return text;
            }
            LOG.info((Object)("Converter " + this.getConverterVersion() + " : Convert report (ver=" + version + ") " + message));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(text.getBytes("UTF-8")));
            Document convertedDoc = this.convert(doc);
            String result = this.transformToXml(convertedDoc);
            if (changeVersion) {
                result = this.changeVersion(result);
            }
            LOG.info((Object)("Converter " + this.getConverterVersion() + " : Report " + message + " converted OK"));
            this.dirty = true;
            return result;
        }
        catch (Throwable t) {
            if (t instanceof ConverterException) {
                throw (ConverterException)t;
            }
            throw new ConverterException("Converter " + this.getConverterVersion() + " : Report " + message + " converted FAILED", t);
        }
    }

    @Override
    public String changeVersion(String xml) throws ConverterException {
        Report report = ReportUtil.loadConvertedReport(xml);
        if (report == null) {
            throw new ConverterException("Converter " + this.getConverterVersion() + " : Report could not be read after conversion");
        }
        report.setVersion(ReleaseInfoAdapter.getVersionNumber());
        return ReportUtil.reportToXml(report);
    }

    private String transformToXml(Document doc) throws Exception {
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("omit-xml-declaration", "yes");
        xformer.setOutputProperty("indent", "yes");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        xformer.transform(new DOMSource(doc), new StreamResult(out));
        return new String(out.toByteArray());
    }

    protected abstract Document convert(Document var1) throws Exception;

    @Override
    public boolean conversionDone() {
        return this.dirty;
    }
}

