/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.util.converter;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ro.nextreports.engine.util.converter.ConverterException;
import ro.nextreports.engine.util.converter.Converter_5_2;
import ro.nextreports.engine.util.converter.NextConverter;

public class ConverterChain {
    private static Log LOG = LogFactory.getLog(ConverterChain.class);
    private static List<NextConverter> converters = new ArrayList<NextConverter>();

    public static String applyFromPath(String path) throws ConverterException {
        String xml = converters.get(0).convertFromPath(path, false);
        xml = ConverterChain.applyFromSecond(xml);
        if (ConverterChain.conversionDone()) {
            return converters.get(converters.size() - 1).changeVersion(xml);
        }
        return xml;
    }

    public static String applyFromInputStream(InputStream is) throws ConverterException {
        String xml = converters.get(0).convertFromInputStream(is, false);
        xml = ConverterChain.applyFromSecond(xml);
        if (ConverterChain.conversionDone()) {
            return converters.get(converters.size() - 1).changeVersion(xml);
        }
        return xml;
    }

    public static String applyFromXml(String text) throws ConverterException {
        String xml = converters.get(0).convertFromXml(text, false);
        xml = ConverterChain.applyFromSecond(xml);
        if (ConverterChain.conversionDone()) {
            return converters.get(converters.size() - 1).changeVersion(xml);
        }
        return xml;
    }

    private static String applyFromSecond(String xml) throws ConverterException {
        int size = converters.size();
        for (int i = 1; i < size; ++i) {
            xml = converters.get(i).convertFromXml(xml, false);
        }
        return xml;
    }

    public static boolean conversionDone() {
        return converters.get(converters.size() - 1).conversionDone();
    }

    static {
        converters.add(new Converter_5_2());
    }
}

