/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.util.converter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ro.nextreports.engine.util.ReportUtil;
import ro.nextreports.engine.util.converter.ConverterChain;
import ro.nextreports.engine.util.converter.ConverterException;

public class ConverterUtil {
    private static Log LOG = LogFactory.getLog(ConverterUtil.class);
    public static byte TYPE_NO_CONVERSION_NEEDED = 0;
    public static byte TYPE_CONVERTED = 1;
    public static byte TYPE_CONVERSION_EXCEPTION = (byte)2;

    public static byte convertIfNeeded(String path) {
        boolean dirty = false;
        try {
            String xml = ConverterChain.applyFromPath(path);
            dirty = ConverterChain.conversionDone();
            if (dirty) {
                ReportUtil.saveReport(xml, path);
                return TYPE_CONVERTED;
            }
            return TYPE_NO_CONVERSION_NEEDED;
        }
        catch (ConverterException ex) {
            ex.printStackTrace();
            LOG.error((Object)ex.getMessage());
            return TYPE_CONVERSION_EXCEPTION;
        }
    }
}

