/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.util.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.awt.Font;

public class FontConverter
implements Converter {
    public boolean canConvert(Class clazz) {
        return clazz.getName().equals("java.awt.Font") || clazz.getName().equals("javax.swing.plaf.FontUIResource");
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        Font font = (Font)value;
        writer.startNode("name");
        writer.setValue(font.getName());
        writer.endNode();
        writer.startNode("size");
        writer.setValue(String.valueOf(font.getSize()));
        writer.endNode();
        writer.startNode("style");
        writer.setValue(String.valueOf(font.getStyle()));
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String name = "Arial";
        int size = 12;
        int style = 0;
        boolean oldFont = false;
        float posture = 0.0f;
        float weight = 1.0f;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String childName = reader.getNodeName();
            if ("name".equals(childName)) {
                name = reader.getValue();
            } else if ("size".equals(childName)) {
                String sizeS = reader.getValue();
                size = Integer.parseInt(sizeS);
            } else if ("style".equals(childName)) {
                String styleS = reader.getValue();
                style = Integer.parseInt(styleS);
            } else if ("attributes".equals(childName)) {
                oldFont = true;
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    boolean isName = false;
                    boolean isSize = false;
                    boolean isWeight = false;
                    boolean isPosture = false;
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        if ("awt-text-attribute".equals(reader.getNodeName())) {
                            if ("family".equals(reader.getValue())) {
                                isName = true;
                            } else if ("size".equals(reader.getValue())) {
                                isSize = true;
                            } else if ("weight".equals(reader.getValue())) {
                                isWeight = true;
                            } else if ("posture".equals(reader.getValue())) {
                                isPosture = true;
                            }
                        } else if ("string".equals(reader.getNodeName())) {
                            if (isName) {
                                name = reader.getValue();
                                isName = false;
                            }
                        } else if ("float".equals(reader.getNodeName())) {
                            if (isSize) {
                                size = (int)Float.parseFloat(reader.getValue());
                                isSize = false;
                            } else if (isPosture) {
                                posture = Float.parseFloat(reader.getValue());
                                isPosture = false;
                            } else if (isWeight) {
                                weight = Float.parseFloat(reader.getValue());
                                isWeight = false;
                            }
                        }
                        reader.moveUp();
                    }
                    reader.moveUp();
                }
            }
            reader.moveUp();
        }
        if (oldFont) {
            style = this.getStyle(posture, weight);
        }
        return new Font(name, style, size);
    }

    private int getStyle(float posture, float weight) {
        if (posture == 0.0f) {
            if (weight == 1.0f) {
                return 0;
            }
            return 1;
        }
        if (weight == 1.0f) {
            return 2;
        }
        return 3;
    }
}

